/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.android.listview;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import de.timroes.android.listview.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class EnhancedListView
extends ListView {
    private float mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private final Object[] mAnimationLock = new Object[0];
    private boolean mSwipeEnabled;
    private OnDismissCallback mDismissCallback;
    private OnShouldSwipeCallback mShouldSwipeCallback;
    private UndoStyle mUndoStyle = UndoStyle.SINGLE_POPUP;
    private boolean mTouchBeforeAutoHide = true;
    private SwipeDirection mSwipeDirection = SwipeDirection.BOTH;
    private int mUndoHideDelay = 5000;
    private int mSwipingLayout;
    private List<Undoable> mUndoActions = new ArrayList<Undoable>();
    private SortedSet<PendingDismissData> mPendingDismisses = new TreeSet<PendingDismissData>();
    private List<View> mAnimatedViews = new LinkedList<View>();
    private int mDismissAnimationRefCount;
    private boolean mSwipePaused;
    private boolean mSwiping;
    private int mViewWidth = 1;
    private View mSwipeDownView;
    private View mSwipeDownChild;
    private TextView mUndoPopupTextView;
    private VelocityTracker mVelocityTracker;
    private float mDownX;
    private int mDownPosition;
    private float mScreenDensity;
    private PopupWindow mUndoPopup;
    private int mValidDelayedMsgId;
    private Handler mHideUndoHandler = new HideUndoPopupHandler();
    private Button mUndoButton;

    public EnhancedListView(Context context) {
        super(context);
        this.init(context);
    }

    public EnhancedListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EnhancedListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context ctx) {
        if (this.isInEditMode()) {
            return;
        }
        ViewConfiguration vc = ViewConfiguration.get((Context)ctx);
        this.mSlop = this.getResources().getDimension(R.dimen.elv_touch_slop);
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = ctx.getResources().getInteger(0x10E0000);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View undoView = inflater.inflate(R.layout.elv_undo_popup, null);
        this.mUndoButton = (Button)undoView.findViewById(R.id.undo);
        this.mUndoButton.setOnClickListener((View.OnClickListener)new UndoClickListener());
        this.mUndoButton.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                EnhancedListView.this.mValidDelayedMsgId++;
                return false;
            }
        });
        this.mUndoPopupTextView = (TextView)undoView.findViewById(R.id.text);
        this.mUndoPopup = new PopupWindow(undoView, -2, -2, false);
        this.mUndoPopup.setAnimationStyle(R.style.elv_fade_animation);
        this.mScreenDensity = this.getResources().getDisplayMetrics().density;
        this.setOnScrollListener(this.makeScrollListener());
    }

    public EnhancedListView enableSwipeToDismiss() {
        if (this.mDismissCallback == null) {
            throw new IllegalStateException("You must pass an OnDismissCallback to the list before enabling Swipe to Dismiss.");
        }
        this.mSwipeEnabled = true;
        return this;
    }

    public EnhancedListView disableSwipeToDismiss() {
        this.mSwipeEnabled = false;
        return this;
    }

    public EnhancedListView setDismissCallback(OnDismissCallback dismissCallback) {
        this.mDismissCallback = dismissCallback;
        return this;
    }

    public EnhancedListView setShouldSwipeCallback(OnShouldSwipeCallback shouldSwipeCallback) {
        this.mShouldSwipeCallback = shouldSwipeCallback;
        return this;
    }

    public EnhancedListView setUndoStyle(UndoStyle undoStyle) {
        this.mUndoStyle = undoStyle;
        return this;
    }

    public EnhancedListView setUndoHideDelay(int hideDelay) {
        this.mUndoHideDelay = hideDelay;
        return this;
    }

    public EnhancedListView setRequireTouchBeforeDismiss(boolean touchBeforeDismiss) {
        this.mTouchBeforeAutoHide = touchBeforeDismiss;
        return this;
    }

    public EnhancedListView setSwipeDirection(SwipeDirection direction) {
        this.mSwipeDirection = direction;
        return this;
    }

    public EnhancedListView setSwipingLayout(int swipingLayoutId) {
        this.mSwipingLayout = swipingLayoutId;
        return this;
    }

    public void discardUndo() {
        for (Undoable undoable : this.mUndoActions) {
            undoable.discard();
        }
        this.mUndoActions.clear();
        if (this.mUndoPopup.isShowing()) {
            this.mUndoPopup.dismiss();
        }
    }

    public void delete(int position) {
        if (this.mDismissCallback == null) {
            throw new IllegalStateException("You must set an OnDismissCallback, before deleting items.");
        }
        if (position < 0 || position >= this.getCount()) {
            throw new IndexOutOfBoundsException(String.format("Tried to delete item %d. #items in list: %d", position, this.getCount()));
        }
        View childView = this.getChildAt(position - this.getFirstVisiblePosition());
        View view = null;
        if (this.mSwipingLayout > 0) {
            view = childView.findViewById(this.mSwipingLayout);
        }
        if (view == null) {
            view = childView;
        }
        this.slideOutView(view, childView, position, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void slideOutView(final View view, final View childView, final int position, boolean toRightSide) {
        Object[] objectArray = this.mAnimationLock;
        synchronized (this.mAnimationLock) {
            if (this.mAnimatedViews.contains(view)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            ++this.mDismissAnimationRefCount;
            this.mAnimatedViews.add(view);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            ViewPropertyAnimator.animate((View)view).translationX(toRightSide ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    EnhancedListView.this.performDismiss(view, childView, position);
                }
            });
            return;
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mSwipeEnabled) {
            return super.onTouchEvent(ev);
        }
        if (this.mTouchBeforeAutoHide && this.mUndoPopup.isShowing()) {
            this.mHideUndoHandler.sendMessageDelayed(this.mHideUndoHandler.obtainMessage(this.mValidDelayedMsgId), (long)this.mUndoHideDelay);
        }
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.getWidth();
        }
        switch (ev.getActionMasked()) {
            case 0: {
                if (this.mSwipePaused) {
                    return super.onTouchEvent(ev);
                }
                Rect rect = new Rect();
                int childCount = this.getChildCount();
                int[] listViewCoords = new int[2];
                this.getLocationOnScreen(listViewCoords);
                int x = (int)ev.getRawX() - listViewCoords[0];
                int y = (int)ev.getRawY() - listViewCoords[1];
                for (int i = this.getHeaderViewsCount(); i < childCount; ++i) {
                    View swipingView;
                    View child = this.getChildAt(i);
                    if (child == null) continue;
                    child.getHitRect(rect);
                    if (!rect.contains(x, y)) continue;
                    if (this.mSwipingLayout > 0 && (swipingView = child.findViewById(this.mSwipingLayout)) != null) {
                        this.mSwipeDownView = swipingView;
                        this.mSwipeDownChild = child;
                        break;
                    }
                    this.mSwipeDownView = this.mSwipeDownChild = child;
                    break;
                }
                if (this.mSwipeDownView != null) {
                    int position = this.getPositionForView(this.mSwipeDownView) - this.getHeaderViewsCount();
                    if (this.mShouldSwipeCallback == null || this.mShouldSwipeCallback.onShouldSwipe(this, position)) {
                        this.mDownX = ev.getRawX();
                        this.mDownPosition = position;
                        this.mVelocityTracker = VelocityTracker.obtain();
                        this.mVelocityTracker.addMovement(ev);
                    } else {
                        this.mSwipeDownChild = null;
                        this.mSwipeDownView = null;
                    }
                }
                super.onTouchEvent(ev);
                return true;
            }
            case 1: {
                if (this.mVelocityTracker == null) break;
                float deltaX = ev.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(ev);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityX = Math.abs(this.mVelocityTracker.getXVelocity());
                float velocityY = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean dismiss = false;
                boolean dismissRight = false;
                if (Math.abs(deltaX) > (float)(this.mViewWidth / 2) && this.mSwiping) {
                    dismiss = true;
                    dismissRight = deltaX > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= velocityX && velocityX <= (float)this.mMaxFlingVelocity && velocityY < velocityX && this.mSwiping && this.isSwipeDirectionValid(this.mVelocityTracker.getXVelocity()) && deltaX >= (float)this.mViewWidth * 0.2f) {
                    dismiss = true;
                    boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
                if (dismiss) {
                    this.slideOutView(this.mSwipeDownView, this.mSwipeDownChild, this.mDownPosition, dismissRight);
                } else if (this.mSwiping) {
                    ViewPropertyAnimator.animate((View)this.mSwipeDownView).translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker = null;
                this.mDownX = 0.0f;
                this.mSwipeDownView = null;
                this.mSwipeDownChild = null;
                this.mDownPosition = -1;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mSwipePaused) break;
                this.mVelocityTracker.addMovement(ev);
                float deltaX = ev.getRawX() - this.mDownX;
                if (this.isSwipeDirectionValid(deltaX)) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    if (Math.abs(deltaX) > this.mSlop) {
                        this.mSwiping = true;
                        this.requestDisallowInterceptTouchEvent(true);
                        MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)ev);
                        cancelEvent.setAction(3 | ev.getActionIndex() << 8);
                        super.onTouchEvent(cancelEvent);
                    }
                } else {
                    this.mDownX = ev.getRawX();
                    deltaX = 0.0f;
                }
                if (!this.mSwiping) break;
                ViewHelper.setTranslationX((View)this.mSwipeDownView, (float)deltaX);
                ViewHelper.setAlpha((View)this.mSwipeDownView, (float)Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
                return true;
            }
        }
        return super.onTouchEvent(ev);
    }

    private void performDismiss(final View dismissView, final View listItemView, int dismissPosition) {
        final ViewGroup.LayoutParams lp = listItemView.getLayoutParams();
        final int originalLayoutHeight = lp.height;
        int originalHeight = listItemView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAnimationEnd(Animator animation) {
                boolean noAnimationLeft;
                Object[] objectArray = EnhancedListView.this.mAnimationLock;
                synchronized (objectArray) {
                    --EnhancedListView.this.mDismissAnimationRefCount;
                    EnhancedListView.this.mAnimatedViews.remove(dismissView);
                    noAnimationLeft = EnhancedListView.this.mDismissAnimationRefCount == 0;
                }
                if (noAnimationLeft) {
                    for (PendingDismissData dismiss : EnhancedListView.this.mPendingDismisses) {
                        Undoable undoable;
                        if (EnhancedListView.this.mUndoStyle == UndoStyle.SINGLE_POPUP) {
                            for (Undoable undoable2 : EnhancedListView.this.mUndoActions) {
                                undoable2.discard();
                            }
                            EnhancedListView.this.mUndoActions.clear();
                        }
                        if ((undoable = EnhancedListView.this.mDismissCallback.onDismiss(EnhancedListView.this, dismiss.position)) != null) {
                            EnhancedListView.this.mUndoActions.add(undoable);
                        }
                        EnhancedListView.this.mValidDelayedMsgId++;
                    }
                    if (!EnhancedListView.this.mUndoActions.isEmpty()) {
                        EnhancedListView.this.changePopupText();
                        EnhancedListView.this.changeButtonLabel();
                        float yLocationOffset = EnhancedListView.this.getResources().getDimension(R.dimen.elv_undo_bottom_offset);
                        EnhancedListView.this.mUndoPopup.setWidth((int)Math.min(EnhancedListView.this.mScreenDensity * 400.0f, (float)EnhancedListView.this.getWidth() * 0.9f));
                        EnhancedListView.this.mUndoPopup.showAtLocation((View)EnhancedListView.this, 81, 0, (int)yLocationOffset);
                        if (!EnhancedListView.this.mTouchBeforeAutoHide) {
                            EnhancedListView.this.mHideUndoHandler.sendMessageDelayed(EnhancedListView.this.mHideUndoHandler.obtainMessage(EnhancedListView.this.mValidDelayedMsgId), (long)EnhancedListView.this.mUndoHideDelay);
                        }
                    }
                    for (PendingDismissData pendingDismiss : EnhancedListView.this.mPendingDismisses) {
                        ViewHelper.setAlpha((View)pendingDismiss.view, (float)1.0f);
                        ViewHelper.setTranslationX((View)pendingDismiss.view, (float)0.0f);
                        ViewGroup.LayoutParams lp = pendingDismiss.childView.getLayoutParams();
                        lp.height = originalLayoutHeight;
                        pendingDismiss.childView.setLayoutParams(lp);
                    }
                    EnhancedListView.this.mPendingDismisses.clear();
                }
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                lp.height = (Integer)valueAnimator.getAnimatedValue();
                listItemView.setLayoutParams(lp);
            }
        });
        this.mPendingDismisses.add(new PendingDismissData(dismissPosition, dismissView, listItemView));
        animator.start();
    }

    private void changePopupText() {
        String msg = null;
        if (this.mUndoActions.size() > 1) {
            msg = this.getResources().getString(R.string.elv_n_items_deleted, new Object[]{this.mUndoActions.size()});
        } else if (this.mUndoActions.size() >= 1 && (msg = this.mUndoActions.get(this.mUndoActions.size() - 1).getTitle()) == null) {
            msg = this.getResources().getString(R.string.elv_item_deleted);
        }
        this.mUndoPopupTextView.setText(msg);
    }

    private void changeButtonLabel() {
        String msg = this.mUndoActions.size() > 1 && this.mUndoStyle == UndoStyle.COLLAPSED_POPUP ? this.getResources().getString(R.string.elv_undo_all) : this.getResources().getString(R.string.elv_undo);
        this.mUndoButton.setText((CharSequence)msg);
    }

    private AbsListView.OnScrollListener makeScrollListener() {
        return new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                EnhancedListView.this.mSwipePaused = scrollState == 1;
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        };
    }

    private boolean isSwipeDirectionValid(float deltaX) {
        int rtlSign = 1;
        if (Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1) {
            rtlSign = -1;
        }
        switch (this.mSwipeDirection) {
            default: {
                return true;
            }
            case START: {
                return (float)rtlSign * deltaX < 0.0f;
            }
            case END: 
        }
        return (float)rtlSign * deltaX > 0.0f;
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility != 0) {
            this.discardUndo();
        }
    }

    private class HideUndoPopupHandler
    extends Handler {
        private HideUndoPopupHandler() {
        }

        public void handleMessage(Message msg) {
            if (msg.what == EnhancedListView.this.mValidDelayedMsgId) {
                EnhancedListView.this.discardUndo();
            }
        }
    }

    private class UndoClickListener
    implements View.OnClickListener {
        private UndoClickListener() {
        }

        public void onClick(View v) {
            if (!EnhancedListView.this.mUndoActions.isEmpty()) {
                switch (EnhancedListView.this.mUndoStyle) {
                    case SINGLE_POPUP: {
                        ((Undoable)EnhancedListView.this.mUndoActions.get(0)).undo();
                        EnhancedListView.this.mUndoActions.clear();
                        break;
                    }
                    case COLLAPSED_POPUP: {
                        Collections.reverse(EnhancedListView.this.mUndoActions);
                        for (Undoable undo : EnhancedListView.this.mUndoActions) {
                            undo.undo();
                        }
                        EnhancedListView.this.mUndoActions.clear();
                        break;
                    }
                    case MULTILEVEL_POPUP: {
                        ((Undoable)EnhancedListView.this.mUndoActions.get(EnhancedListView.this.mUndoActions.size() - 1)).undo();
                        EnhancedListView.this.mUndoActions.remove(EnhancedListView.this.mUndoActions.size() - 1);
                    }
                }
            }
            if (EnhancedListView.this.mUndoActions.isEmpty()) {
                if (EnhancedListView.this.mUndoPopup.isShowing()) {
                    EnhancedListView.this.mUndoPopup.dismiss();
                }
            } else {
                EnhancedListView.this.changePopupText();
                EnhancedListView.this.changeButtonLabel();
            }
            EnhancedListView.this.mValidDelayedMsgId++;
        }
    }

    private class PendingDismissData
    implements Comparable<PendingDismissData> {
        public int position;
        public View view;
        public View childView;

        PendingDismissData(int position, View view, View childView) {
            this.position = position;
            this.view = view;
            this.childView = childView;
        }

        @Override
        public int compareTo(PendingDismissData other) {
            return other.position - this.position;
        }
    }

    public static abstract class Undoable {
        public abstract void undo();

        public String getTitle() {
            return null;
        }

        public void discard() {
        }
    }

    public static interface OnDismissCallback {
        public Undoable onDismiss(EnhancedListView var1, int var2);
    }

    public static interface OnShouldSwipeCallback {
        public boolean onShouldSwipe(EnhancedListView var1, int var2);
    }

    public static enum SwipeDirection {
        BOTH,
        START,
        END;

    }

    public static enum UndoStyle {
        SINGLE_POPUP,
        MULTILEVEL_POPUP,
        COLLAPSED_POPUP;

    }
}

