/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.ColorUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;

final class Utils {
    private static final float CIRCLE_CONSTANT = 0.5522848f;
    private static final Map<String, Float> FONT_HEIGHT_CACHE = new HashMap<String, Float>();

    private Utils() {
    }

    static float measureTextSize(PDFont font, int fontSize, String text) {
        try {
            return font.getStringWidth(text) / 1000.0f * (float)fontSize;
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem with font", e);
        }
    }

    static synchronized float getFontHeight(PDFont font, float fontSize) {
        try {
            String key = font.getName() + "_" + font.getType() + "_" + font.getSubType();
            Float lineHeight = FONT_HEIGHT_CACHE.get(key);
            if (lineHeight == null) {
                lineHeight = Float.valueOf(0.0f);
                for (char c : new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'}) {
                    lineHeight = Float.valueOf(Math.max(lineHeight.floatValue(), font.getHeight((int)c)));
                }
                lineHeight = Float.valueOf(lineHeight.floatValue() / 1000.0f);
                FONT_HEIGHT_CACHE.put(key, lineHeight);
            }
            return lineHeight.floatValue() * fontSize;
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem with font", e);
        }
    }

    static Color htmlColorToColor(String color) {
        if (color.startsWith("#")) {
            try {
                return new Color(Integer.parseInt(color.substring(1), 16));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            if (color.startsWith("rgb")) {
                Pattern pattern = Pattern.compile("rgb\\( *([0-9]+), *([0-9]+), *([0-9]+)\\)");
                Color colorObject = null;
                Matcher matcher = pattern.matcher(color);
                if (matcher.matches()) {
                    colorObject = new Color(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                }
                return colorObject;
            }
            if (color.startsWith("hsl")) {
                Pattern pattern = Pattern.compile("hsl\\( *([0-9]+), *([0-9]+)%, *([0-9]+)%\\)");
                Color colorObject = null;
                Matcher matcher = pattern.matcher(color);
                if (matcher.matches()) {
                    colorObject = ColorUtils.getHSLColor(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                }
                return colorObject;
            }
            switch (color.trim().toLowerCase()) {
                case "black": {
                    return null;
                }
                case "red": {
                    return Color.RED;
                }
                case "green": {
                    return Color.GREEN;
                }
                case "blue": {
                    return Color.BLUE;
                }
                case "yellow": {
                    return Color.YELLOW;
                }
            }
        }
        return null;
    }

    static void drawCircle(PDPageContentStream stream, float x, float y, float r) throws IOException {
        stream.moveTo(x - r, y);
        stream.curveTo(x - r, y + 0.5522848f * r, x - 0.5522848f * r, y + r, x, y + r);
        stream.curveTo(x + 0.5522848f * r, y + r, x + r, y + 0.5522848f * r, x + r, y);
        stream.curveTo(x + r, y - 0.5522848f * r, x + 0.5522848f * r, y - r, x, y - r);
        stream.curveTo(x - 0.5522848f * r, y - r, x - r, y - 0.5522848f * r, x - r, y);
    }
}

