/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.PDFPageWithStream;
import com.moebiusgames.pdfbox.table.PDFRenderContext;
import com.moebiusgames.pdfbox.table.PDFTableCell;
import com.moebiusgames.pdfbox.table.PDFTableColumn;
import com.moebiusgames.pdfbox.table.PDFTableRow;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class PDFTable {
    public static int NOT_SET = -1;
    public static final float AUTO_DETERMINE_COLUMN_WIDTH = Float.NEGATIVE_INFINITY;
    public static Color NOT_SET_COLOR = new Color(255, 0, 255, 0);
    private final PageSettings pageSettings = new PageSettings();
    private final List<PDFTableColumn> columns = new ArrayList<PDFTableColumn>();
    private final List<PDFTableRow> rows = new ArrayList<PDFTableRow>();
    private ColumnHeadersMode columnHeadersMode = ColumnHeadersMode.COLUMN_HEADERS_ON_FIRST_PAGE;

    public PDFTable(float ... columnWidths) {
        for (int i = 0; i < columnWidths.length; ++i) {
            if (columnWidths[i] < 0.0f) {
                throw new IllegalArgumentException("column " + (i + 1) + " size is < 0");
            }
            this.columns.add(new PDFTableColumn(this, columnWidths[i]));
        }
    }

    public PageSettings getPageSettings() {
        return this.pageSettings;
    }

    public ColumnHeadersMode getColumnHeadersMode() {
        return this.columnHeadersMode;
    }

    public void setColumnHeadersMode(ColumnHeadersMode columnHeadersMode) {
        if (columnHeadersMode == null) {
            throw new IllegalArgumentException("null is not allowed");
        }
        this.columnHeadersMode = columnHeadersMode;
    }

    public PDFTableColumn getColumn(int index) {
        if (index < 0 || index >= this.columns.size()) {
            throw new IllegalArgumentException("index is out of range");
        }
        return this.columns.get(index);
    }

    public int getColumns() {
        return this.columns.size();
    }

    public PDFTableRow addRow() {
        PDFTableRow row = new PDFTableRow(this, this.rows.size());
        this.rows.add(row);
        return row;
    }

    public int getRows() {
        return this.rows.size();
    }

    public PDFTableRow getRow(int index) {
        if (index < 0 || index >= this.rows.size()) {
            throw new IllegalArgumentException("index is out of range");
        }
        return this.rows.get(index);
    }

    public void render(PDFRenderContext renderContext, float x) throws IOException {
        this.render(renderContext, renderContext.getLastPage(), x, renderContext.getLastPage().getRenderedYPosition());
    }

    public void render(PDFRenderContext renderContext, float x, float y) throws IOException {
        this.render(renderContext, renderContext.getLastPage(), x, y);
    }

    public void render(PDFRenderContext renderContext, PDFPageWithStream page, float x, float y) throws IOException {
        PDFTableRow headingRow = this.prepareHeadingRow();
        PagePosition pos = new PagePosition(x, y);
        if (this.columnHeadersMode == ColumnHeadersMode.COLUMN_HEADERS_ON_FIRST_PAGE || this.columnHeadersMode == ColumnHeadersMode.COLUMN_HEADERS_ON_EVERY_PAGE) {
            page = this.renderRow(page, headingRow, null, pos, x, renderContext, true);
        }
        for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
            PDFTableRow row = this.rows.get(rowIndex);
            page = this.renderRow(page, row, headingRow, pos, x, renderContext);
        }
    }

    private PDFPageWithStream renderRow(PDFPageWithStream currentPage, PDFTableRow row, PDFTableRow headingRow, PagePosition pos, float x, PDFRenderContext renderContext) throws IOException {
        return this.renderRow(currentPage, row, headingRow, pos, x, renderContext, false);
    }

    private PDFPageWithStream renderRow(PDFPageWithStream currentPage, PDFTableRow row, PDFTableRow headingRow, PagePosition pos, float x, PDFRenderContext renderContext, boolean forceTopBorder) throws IOException {
        boolean newPage;
        pos.x = x;
        ArrayList<CellRenderInfo> cellInfosList = new ArrayList<CellRenderInfo>(row.cells.size());
        for (int colIndex = 0; colIndex < row.cells.size(); ++colIndex) {
            PDFTableCell cell = row.getCell(colIndex);
            if (cell == null) continue;
            cellInfosList.add(new CellRenderInfo(cell));
        }
        float freeSpace = pos.y - this.pageSettings.getMarginBottom();
        boolean bl = newPage = freeSpace <= 0.0f;
        while (cellInfosList.stream().anyMatch(cellInfo -> !cellInfo.isDone())) {
            if (newPage) {
                currentPage = renderContext.getOrCreateNextPage(currentPage);
                pos.y = currentPage.getPage().getMediaBox().getHeight() - this.pageSettings.getMarginTop();
                pos.x = x;
                if (headingRow != null && this.columnHeadersMode == ColumnHeadersMode.COLUMN_HEADERS_ON_EVERY_PAGE) {
                    currentPage = this.renderRow(currentPage, headingRow, null, pos, x, renderContext);
                    pos.x = x;
                    currentPage.setRenderedYPosition(pos.y);
                }
                freeSpace = pos.y - this.pageSettings.getMarginBottom();
            }
            LinkedList cellInfosQueue = new LinkedList(cellInfosList);
            while (!cellInfosQueue.isEmpty()) {
                Iterator iterator = cellInfosQueue.iterator();
                while (iterator.hasNext()) {
                    CellRenderInfo cellInfo2 = (CellRenderInfo)iterator.next();
                    if (cellInfo2.isDone()) {
                        iterator.remove();
                        continue;
                    }
                    if (!cellInfo2.incEndRow()) {
                        iterator.remove();
                        continue;
                    }
                    if (!(cellInfo2.getHeight() > freeSpace)) continue;
                    cellInfo2.decEndRow();
                    iterator.remove();
                }
            }
            float maxHeight = cellInfosList.stream().map(cellInfo -> Float.valueOf(cellInfo.getHeight())).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
            boolean pageBreakBefore = currentPage.isFreshPage();
            for (CellRenderInfo cellInfo3 : cellInfosList) {
                cellInfo3.render(currentPage.getOrCreateStream(), pos, maxHeight, pageBreakBefore, forceTopBorder);
            }
            pos.y -= maxHeight;
            newPage = true;
            currentPage.setRenderedYPosition(pos.y);
        }
        return currentPage;
    }

    private PDFTableRow prepareHeadingRow() {
        PDFTableRow headingRow = new PDFTableRow(this, -1);
        for (int colIndex = 0; colIndex < this.columns.size(); ++colIndex) {
            PDFTableCell cell = headingRow.getCell(colIndex);
            PDFTableColumn column = this.columns.get(colIndex);
            cell.setContent(column.getHeading());
            cell.setAlign(column.getHeadingAlign());
            cell.setFontColor(column.getHeadingFontColor());
            cell.setBackgroundColor(column.getHeadingBackgroundColor());
            cell.setFont(column.getHeadingFont());
            cell.setFontSize(column.getHeadingFontSize());
            cell.setUnderline(column.getUnderline());
        }
        return headingRow;
    }

    public float getHeight() throws IOException {
        List<Float> rowHeights = this.getRowHeights();
        PDFTableRow headingRow = this.prepareHeadingRow();
        float headingRowHeight = headingRow.getMaxHeight();
        return rowHeights.stream().reduce(Float.valueOf(0.0f), (sum, height) -> {
            sum = Float.valueOf(sum.floatValue() + height.floatValue());
            return sum;
        }, (sum1, sum2) -> Float.valueOf(sum1.floatValue() + sum2.floatValue())).floatValue() + (this.getColumnHeadersMode() == ColumnHeadersMode.NO_COLUMN_HEADERS ? 0.0f : headingRowHeight);
    }

    private List<Float> getRowHeights() throws IOException {
        ArrayList<Float> rowHeights = new ArrayList<Float>();
        for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
            PDFTableRow row = this.rows.get(rowIndex);
            rowHeights.add(Float.valueOf(row.getMaxHeight()));
        }
        return rowHeights;
    }

    public static PDFTable createByRelativeColumnWidth(float tableWidth, float ... columnWidthPercent) {
        float[] columnWidths = new float[columnWidthPercent.length];
        float total = 0.0f;
        for (int i = 0; i < columnWidthPercent.length; ++i) {
            columnWidths[i] = tableWidth * columnWidthPercent[i];
            if (!((total += columnWidthPercent[i]) > 1.0f)) continue;
            throw new IllegalArgumentException("Column widths sum up to be greater thatn 1.0");
        }
        return new PDFTable(columnWidths);
    }

    public static PDFTable createWithSomeFixedColumnWidths(float tableWidth, float ... columnWidths) {
        float[] resultWidths = new float[columnWidths.length];
        int undefinedColumns = 0;
        for (int i = 0; i < columnWidths.length; ++i) {
            if (columnWidths[i] != Float.NEGATIVE_INFINITY) {
                if ((tableWidth -= columnWidths[i]) < 0.0f) {
                    throw new IllegalArgumentException("sum of column widths are greater than the given table width");
                }
                resultWidths[i] = columnWidths[i];
                continue;
            }
            ++undefinedColumns;
        }
        if (undefinedColumns > 0) {
            float undefinedColumnsWidth = tableWidth / (float)undefinedColumns;
            for (int i = 0; i < columnWidths.length; ++i) {
                if (columnWidths[i] != Float.NEGATIVE_INFINITY) continue;
                resultWidths[i] = undefinedColumnsWidth;
            }
        }
        return new PDFTable(resultWidths);
    }

    public static class PageSettings {
        private float marginTop = 28.346458f;
        private float marginBottom = 56.692917f;

        public float getMarginTop() {
            return this.marginTop;
        }

        public void setMarginTop(float marginTop) {
            if (marginTop < 0.0f) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.marginTop = marginTop;
        }

        public float getMarginBottom() {
            return this.marginBottom;
        }

        public void setMarginBottom(float marginBottom) {
            if (marginBottom < 0.0f) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.marginBottom = marginBottom;
        }
    }

    public static enum ColumnHeadersMode {
        NO_COLUMN_HEADERS,
        COLUMN_HEADERS_ON_FIRST_PAGE,
        COLUMN_HEADERS_ON_EVERY_PAGE;

    }

    private static class PagePosition {
        private float x;
        private float y;

        public PagePosition(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class CellRenderInfo {
        private final PDFTableCell cell;
        private int startRow;
        private int endRow;

        public CellRenderInfo(PDFTableCell cell) {
            this.cell = cell;
            this.cell.updateContentLayout();
        }

        public float getHeight() {
            return this.cell.getLaidoutContent().getHeight(this.startRow, this.endRow) + this.cell.getPaddingBottom() + this.cell.getPaddingTop();
        }

        public boolean incEndRow() {
            if (this.endRow < this.cell.getLaidoutContent().getNumRows()) {
                ++this.endRow;
                return true;
            }
            return false;
        }

        public void decEndRow() {
            if (this.endRow > this.startRow + 1) {
                --this.endRow;
            }
        }

        public void render(PDPageContentStream stream, PagePosition pos, float rowMaxHeight, boolean pageBreakBefore, boolean forceTopBorder) throws IOException {
            this.cell.render(stream, pos.x, pos.y, this.startRow, this.endRow, rowMaxHeight, pageBreakBefore || forceTopBorder);
            this.startRow = this.endRow;
            pos.x += this.cell.getWidth();
        }

        public boolean isDone() {
            return this.startRow >= this.cell.getLaidoutContent().getNumRows();
        }
    }
}

