/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class PDFPageWithStream {
    private final PDDocument doc;
    private final PDPage page;
    private PDPageContentStream stream;
    private float renderedYPosition;

    public PDFPageWithStream(PDDocument doc, PDPage page) {
        this(doc, page, null);
    }

    public PDFPageWithStream(PDDocument doc, PDPage page, PDPageContentStream stream) {
        this.doc = doc;
        this.page = page;
        this.stream = stream;
        this.renderedYPosition = page.getMediaBox().getHeight();
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public PDPage getPage() {
        return this.page;
    }

    public boolean isFreshPage() {
        return this.stream == null;
    }

    public PDPageContentStream getOrCreateStream() throws IOException {
        if (this.stream == null) {
            this.stream = new PDPageContentStream(this.doc, this.page);
        }
        return this.stream;
    }

    public float getRenderedYPosition() {
        return this.renderedYPosition;
    }

    public void setRenderedYPosition(float renderedYPosition) {
        this.renderedYPosition = renderedYPosition;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

