/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.PDFPageWithStream;
import com.moebiusgames.pdfbox.table.PDFRenderContext;
import com.moebiusgames.pdfbox.table.PDFTable;
import com.moebiusgames.pdfbox.table.PDFTableBorder;
import com.moebiusgames.pdfbox.table.PDFTableCell;
import com.moebiusgames.pdfbox.table.PDFTableRow;
import com.moebiusgames.pdfbox.table.TextType;
import java.io.IOException;

public class PDFLabel {
    private final PDFTable table;
    private final PDFTableRow row;

    public PDFLabel(float width) {
        this(width, TextType.PLAIN);
    }

    public PDFLabel(float width, TextType textType) {
        this.table = new PDFTable(width);
        this.table.setColumnHeadersMode(PDFTable.ColumnHeadersMode.NO_COLUMN_HEADERS);
        this.row = this.table.addRow();
        PDFTableBorder noBorder = new PDFTableBorder();
        noBorder.setLineWidth(0.0f);
        this.getCell().setBorderBottom(noBorder).setBorderTop(noBorder).setBorderLeft(noBorder).setBorderRight(noBorder).setTextType(textType);
    }

    public void setText(String text) {
        this.getCell().setContent(text);
    }

    public final PDFTableCell getCell() {
        return this.row.getCell(0);
    }

    public void render(PDFRenderContext renderContext, float x) throws IOException {
        this.table.render(renderContext, x);
    }

    public void render(PDFRenderContext renderContext, float x, float y) throws IOException {
        this.table.render(renderContext, x, y);
    }

    public void render(PDFRenderContext renderContext, PDFPageWithStream page, float x, float y) throws IOException {
        this.table.render(renderContext, page, x, y);
    }
}

