/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.CalledMethod;
import de.flapdoodle.testdoc.End;
import de.flapdoodle.testdoc.HasLine;
import de.flapdoodle.testdoc.Includes;
import de.flapdoodle.testdoc.Line;
import de.flapdoodle.testdoc.Preconditions;
import de.flapdoodle.testdoc.Recordings;
import de.flapdoodle.testdoc.Renderer;
import de.flapdoodle.testdoc.ResourceFilter;
import de.flapdoodle.testdoc.Resources;
import de.flapdoodle.testdoc.Stacktraces;
import de.flapdoodle.testdoc.Start;
import de.flapdoodle.testdoc.TabSize;
import de.flapdoodle.testdoc.TemplateReference;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Recording
implements AfterAllCallback {
    private static final String DEST_DIR_PROPERTY = "de.flapdoodle.testdoc.destination";
    private static final ThreadLocal<RenderOutputDelegate> templateConsumer = new ThreadLocal();
    private final TemplateReference templateReference;
    private final List<String> testSourceCode;
    private final List<HasLine> lines = new ArrayList<HasLine>();
    private final Map<String, CalledMethod> calledMethod = new LinkedHashMap<String, CalledMethod>();
    private final Map<String, String> classes = new LinkedHashMap<String, String>();
    private final Map<String, String> resources = new LinkedHashMap<String, String>();
    private final Map<String, String> output = new LinkedHashMap<String, String>();
    private final Map<String, byte[]> files = new LinkedHashMap<String, byte[]>();
    private final TabSize tabSize;
    private Optional<BiFunction<String, Set<String>, String>> replacementNotFoundFallback = Optional.empty();
    private Optional<String> renderTo = Optional.empty();

    protected Recording(TemplateReference templateReference, List<String> testSourceCode, TabSize tabSize) {
        this.tabSize = tabSize;
        this.templateReference = Preconditions.checkNotNull(templateReference, "template name is null", new Object[0]);
        this.testSourceCode = new ArrayList<String>((Collection)Preconditions.checkNotNull(testSourceCode, "linesOfCode is null", new Object[0]));
    }

    public Recording sourceCodeOf(String label, Class<?> clazz, Includes ... includeOptions) {
        Optional<List<String>> sourceCode = Resources.sourceCodeOf(clazz, this.tabSize, includeOptions);
        Preconditions.checkArgument(sourceCode.isPresent(), "could not find sourceCode of %s", clazz);
        String old = this.classes.put(label, Resources.joinedWithNewLine((Collection<String>)sourceCode.get()));
        Preconditions.checkArgument(old == null, "sourceCodeOf with label %s was already set to %s", label, old);
        return this;
    }

    @Deprecated
    public Recording thisMethod(String label) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        CalledMethod old = this.calledMethod.put(label, CalledMethod.of(currentLine));
        Preconditions.checkArgument(old == null, "method with label %s was already set to %s", label, old);
        return this;
    }

    public Recording resource(String label, Class<?> clazz, String resourceName, ResourceFilter ... filters) {
        Optional<String> resource = Resources.resource(clazz, resourceName);
        Preconditions.checkArgument(resource.isPresent(), "could not find resource of %s:%s", clazz, resourceName);
        String old = this.resources.put(label, resource.map(ResourceFilter.join(filters)).get());
        Preconditions.checkArgument(old == null, "resource with label %s was already set to %s", label, old);
        return this;
    }

    public Recording replacementNotFoundFallback(BiFunction<String, Set<String>, String> fallback) {
        Preconditions.checkArgument(!this.replacementNotFoundFallback.isPresent(), "already set to: %s", this.replacementNotFoundFallback);
        this.replacementNotFoundFallback = Optional.of(fallback);
        return this;
    }

    public Recording renderTo(String destination) {
        Preconditions.checkNotNull(destination, "destination is null", new Object[0]);
        Preconditions.checkArgument(!this.renderTo.isPresent(), "destination already set to: %s", this.renderTo);
        this.renderTo = Optional.of(destination);
        return this;
    }

    public void afterAll(ExtensionContext extensionContext) {
        String renderedTemplate = Renderer.renderTemplate(Recordings.builder().templateReference(this.templateReference).linesOfCode(this.testSourceCode).lines(this.lines).methodsCalled(this.calledMethod).classes(this.classes).resources(this.resources).output(this.output).replacementNotFoundFallback(this.replacementNotFoundFallback).build());
        Recording.writeResult(this.renderTo.orElse(this.templateReference.templateName()), renderedTemplate, this.files);
    }

    protected static void writeResult(String templateName, String renderedTemplate, Map<String, byte[]> files) {
        if (templateConsumer.get() != null) {
            templateConsumer.get().writeResult(templateName, renderedTemplate, files);
        } else {
            String destination = System.getProperty(DEST_DIR_PROPERTY);
            if (destination != null) {
                Path destinationPath = Paths.get(destination, new String[0]);
                Preconditions.checkArgument(Files.exists(destinationPath, new LinkOption[0]), "%s does not exist", destinationPath);
                Preconditions.checkArgument(Files.isDirectory(destinationPath, new LinkOption[0]), "%s is not a directory", destinationPath);
                Path output = destinationPath.resolve(templateName);
                try {
                    Recording.createParentDirectoryIfNeeded(output);
                    Files.write(output, renderedTemplate.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    for (Map.Entry<String, byte[]> entry : files.entrySet()) {
                        Path filePath = Recording.createParentDirectoryIfNeeded(destinationPath.resolve(entry.getKey()));
                        Files.write(filePath, entry.getValue(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    }
                }
                catch (IOException iox) {
                    throw new RuntimeException("could not write " + output, iox);
                }
            } else {
                System.out.println("de.flapdoodle.testdoc.destination not set");
                System.out.println("---------------------------");
                System.out.println("should write " + templateName);
                System.out.println("---------------------------");
                System.out.println(renderedTemplate);
                System.out.println("---------------------------");
                files.forEach((file, content) -> System.out.println("- " + file + " -> " + ((byte[])content).length + " bytes"));
                if (!files.isEmpty()) {
                    System.out.println("---------------------------");
                }
            }
        }
    }

    private static Path createParentDirectoryIfNeeded(Path filePath) throws IOException {
        Path parent = filePath.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return filePath;
    }

    public void include(Class<?> clazz, Includes ... includeOptions) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        String label = currentLine.methodName() + "." + clazz.getSimpleName();
        this.sourceCodeOf(label, clazz, includeOptions);
    }

    public void resource(Class<?> clazz, String resourceName, ResourceFilter ... filters) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        String label = currentLine.methodName() + "." + clazz.getSimpleName() + ":" + resourceName;
        this.resource(label, clazz, resourceName, filters);
    }

    public void output(String label, String content) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        String scopedLabel = currentLine.methodName() + "." + label;
        String old = this.output.put(scopedLabel, content);
        Preconditions.checkArgument(old == null, "%s already set to %s", label, old);
    }

    public void file(String label, String fileName, byte[] content) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        String scopedLabel = currentLine.methodName() + "." + label;
        String old = this.output.put(scopedLabel, fileName);
        Preconditions.checkArgument(old == null, "%s already set to %s", label, old);
        byte[] oldContent = this.files.put(fileName, Arrays.copyOf(content, content.length));
        Preconditions.checkArgument(oldContent == null, "%s/%s already set", label, fileName);
    }

    public void begin() {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        this.lines.add(Start.of(currentLine));
    }

    public void begin(String label) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        this.lines.add(Start.of(label, currentLine));
    }

    public void end() {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        this.lines.add(End.of(currentLine));
    }

    private static RenderOutputDelegate setTemplateConsumerForInternalUse(RenderOutputDelegate consumer) {
        RenderOutputDelegate old = templateConsumer.get();
        templateConsumer.set(consumer);
        return old;
    }

    protected static Consumer<Runnable> runWithTemplateConsumer(RenderOutputDelegate consumer) {
        return runnable -> {
            RenderOutputDelegate old = Recording.setTemplateConsumerForInternalUse(consumer);
            try {
                runnable.run();
            }
            finally {
                Recording.setTemplateConsumerForInternalUse(old);
            }
        };
    }

    public static interface RenderOutputDelegate {
        public void writeResult(String var1, String var2, Map<String, byte[]> var3);
    }
}

