/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Preconditions {
    private static Pattern PLACEHOLDER = Pattern.compile("%s");

    private Preconditions() {
    }

    public static void checkArgument(boolean expression, String errorMessage, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessage, args));
        }
    }

    public static <T> T checkNotNull(T reference, String errorMessage, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(Preconditions.format(errorMessage, args));
        }
        return reference;
    }

    public static <T> Optional<T> checkPresent(Optional<T> reference, String errorMessage, Object ... args) {
        if (!reference.isPresent()) {
            throw new IllegalArgumentException(Preconditions.format(errorMessage, args));
        }
        return reference;
    }

    protected static String format(String message, Object ... args) {
        if (args.length > 0) {
            int currentArg = 0;
            int last = 0;
            StringBuilder sb = new StringBuilder();
            Matcher matcher = PLACEHOLDER.matcher(message);
            while (matcher.find()) {
                sb.append(message.substring(last, matcher.start()));
                if (currentArg < args.length) {
                    sb.append(Preconditions.asObject(args[currentArg++]));
                } else {
                    sb.append("<arg").append(currentArg).append(">");
                }
                last = matcher.end();
            }
            sb.append(message.substring(last));
            for (int i = currentArg; i < args.length; ++i) {
                sb.append(",").append(Preconditions.asObject(args[i]));
            }
            return sb.toString();
        }
        return message;
    }

    protected static Object asObject(Object value) {
        if (value instanceof LazyArgument) {
            return ((LazyArgument)value).get();
        }
        return value;
    }

    public static LazyArgument lazy(Supplier<?> supplier) {
        return () -> supplier.get();
    }

    public static interface LazyArgument
    extends Supplier<Object> {
    }
}

