/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.attributes;

import de.flapdoodle.os.common.attributes.TextFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TextFile", generator="Immutables")
public final class ImmutableTextFile
implements TextFile {
    private final String name;
    private final Charset charset;

    private ImmutableTextFile(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.charset = Objects.requireNonNull(TextFile.super.charset(), "charset");
    }

    private ImmutableTextFile(Builder builder) {
        this.name = builder.name;
        this.charset = builder.charset != null ? builder.charset : Objects.requireNonNull(TextFile.super.charset(), "charset");
    }

    private ImmutableTextFile(String name, Charset charset) {
        this.name = name;
        this.charset = charset;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    public final ImmutableTextFile withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTextFile(newValue, this.charset);
    }

    public final ImmutableTextFile withCharset(Charset value) {
        if (this.charset == value) {
            return this;
        }
        Charset newValue = Objects.requireNonNull(value, "charset");
        return new ImmutableTextFile(this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextFile && this.equalTo((ImmutableTextFile)another);
    }

    private boolean equalTo(ImmutableTextFile another) {
        return this.name.equals(another.name) && this.charset.equals(another.charset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.charset.hashCode();
        return h;
    }

    public String toString() {
        return "TextFile{name=" + this.name + ", charset=" + this.charset + "}";
    }

    public static ImmutableTextFile of(String name) {
        return new ImmutableTextFile(name);
    }

    public static ImmutableTextFile copyOf(TextFile instance) {
        if (instance instanceof ImmutableTextFile) {
            return (ImmutableTextFile)instance;
        }
        return ImmutableTextFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TextFile", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private Charset charset;

        private Builder() {
        }

        public final Builder from(TextFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.charset(instance.charset());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder charset(Charset charset) {
            this.charset = Objects.requireNonNull(charset, "charset");
            return this;
        }

        public ImmutableTextFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTextFile(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build TextFile, some of required attributes are not set " + attributes;
        }
    }
}

