/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element;

import cn.hutool.core.collection.CollUtil;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.ArrayList;
import java.util.List;

public class Chain
implements Executable {
    private static final LFLog LOG = LFLoggerManager.getLogger(Chain.class);
    private String chainId;
    private List<Condition> conditionList = new ArrayList<Condition>();

    public Chain(String chainName) {
        this.chainId = chainName;
    }

    public Chain() {
    }

    public Chain(String chainName, List<Condition> conditionList) {
        this.chainId = chainName;
        this.conditionList = conditionList;
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    public void setConditionList(List<Condition> conditionList) {
        this.conditionList = conditionList;
    }

    @Deprecated
    public String getChainName() {
        return this.chainId;
    }

    public void setChainName(String chainName) {
        this.chainId = chainName;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    @Override
    public void execute(Integer slotIndex) throws Exception {
        if (CollUtil.isEmpty(this.conditionList)) {
            throw new FlowSystemException("no conditionList in this chain[" + this.chainId + "]");
        }
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            slot.setChainId(this.chainId);
            for (Condition condition : this.conditionList) {
                condition.setCurrChainId(this.chainId);
                condition.execute(slotIndex);
            }
        }
        catch (ChainEndException e) {
            throw e;
        }
        catch (Exception e) {
            if (slot.isSubChain(this.chainId)) {
                slot.setSubException(this.chainId, e);
            } else {
                slot.setException(e);
            }
            throw e;
        }
    }

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.CHAIN;
    }

    @Override
    public void setId(String id) {
        this.chainId = id;
    }

    @Override
    public String getId() {
        return this.chainId;
    }

    @Override
    public void setTag(String tag) {
    }

    @Override
    public String getTag() {
        return null;
    }
}

