/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.NoWhileNodeException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;

public class WhileCondition
extends LoopCondition {
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        Node whileNode = this.getWhileNode();
        if (ObjectUtil.isNull((Object)whileNode)) {
            String errorInfo = StrUtil.format((CharSequence)"[{}]:no while-node found", (Object[])new Object[]{slot.getRequestId()});
            throw new NoWhileNodeException(errorInfo);
        }
        if (!this.getWhileNode().isAccess(slotIndex)) {
            return;
        }
        Executable executableItem = this.getDoExecutor();
        Node breakNode = this.getBreakNode();
        int index = 0;
        while (this.getWhileResult(slotIndex)) {
            executableItem.setCurrChainId(this.getCurrChainId());
            this.setLoopIndex(executableItem, index);
            executableItem.execute(slotIndex);
            if (ObjectUtil.isNotNull((Object)breakNode)) {
                breakNode.setCurrChainId(this.getCurrChainId());
                this.setLoopIndex(breakNode, index);
                breakNode.execute(slotIndex);
                Class<?> originalBreakClass = LiteFlowProxyUtil.getUserClass(breakNode.getInstance().getClass());
                boolean isBreak = slot.getBreakResult(originalBreakClass.getName());
                if (isBreak) break;
            }
            ++index;
        }
    }

    private boolean getWhileResult(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        Node whileNode = this.getWhileNode();
        whileNode.setCurrChainId(this.getCurrChainId());
        whileNode.execute(slotIndex);
        Class<?> originalWhileClass = LiteFlowProxyUtil.getUserClass(whileNode.getInstance().getClass());
        return slot.getWhileResult(originalWhileClass.getName());
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_WHILE;
    }

    public Node getWhileNode() {
        return (Node)this.getExecutableOne("WHILE_KEY");
    }

    public void setWhileNode(Node whileNode) {
        this.addExecutable("WHILE_KEY", whileNode);
    }
}

