/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.IfTargetCannotBePreOrFinallyException;
import com.yomahub.liteflow.exception.IfTypeErrorException;
import com.yomahub.liteflow.exception.NoIfTrueNodeException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;

public class IfCondition
extends Condition {
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        if (ListUtil.toList((Object[])new NodeTypeEnum[]{NodeTypeEnum.IF, NodeTypeEnum.IF_SCRIPT}).contains((Object)this.getIfNode().getType())) {
            if (!this.getIfNode().isAccess(slotIndex)) {
                return;
            }
            this.getIfNode().setCurrChainId(this.getCurrChainId());
            this.getIfNode().execute(slotIndex);
            Slot slot = DataBus.getSlot(slotIndex);
            Class<?> originalClass = LiteFlowProxyUtil.getUserClass(this.getIfNode().getInstance().getClass());
            boolean ifResult = slot.getIfResult(originalClass.getName());
            Executable trueCaseExecutableItem = this.getTrueCaseExecutableItem();
            Executable falseCaseExecutableItem = this.getFalseCaseExecutableItem();
            if (ifResult) {
                if (ObjectUtil.isNull((Object)trueCaseExecutableItem)) {
                    String errorInfo = StrUtil.format((CharSequence)"[{}]:no if-true node found for the component[{}]", (Object[])new Object[]{slot.getRequestId(), this.getIfNode().getInstance().getDisplayName()});
                    throw new NoIfTrueNodeException(errorInfo);
                }
                if (trueCaseExecutableItem instanceof PreCondition || trueCaseExecutableItem instanceof FinallyCondition) {
                    String errorInfo = StrUtil.format((CharSequence)"[{}]:if component[{}] error, if true node cannot be pre or finally", (Object[])new Object[]{slot.getRequestId(), this.getIfNode().getInstance().getDisplayName()});
                    throw new IfTargetCannotBePreOrFinallyException(errorInfo);
                }
                trueCaseExecutableItem.setCurrChainId(this.getCurrChainId());
                trueCaseExecutableItem.execute(slotIndex);
            } else if (ObjectUtil.isNotNull((Object)falseCaseExecutableItem)) {
                if (falseCaseExecutableItem instanceof PreCondition || falseCaseExecutableItem instanceof FinallyCondition) {
                    String errorInfo = StrUtil.format((CharSequence)"[{}]:if component[{}] error, if true node cannot be pre or finally", (Object[])new Object[]{slot.getRequestId(), this.getIfNode().getInstance().getDisplayName()});
                    throw new IfTargetCannotBePreOrFinallyException(errorInfo);
                }
                falseCaseExecutableItem.setCurrChainId(this.getCurrChainId());
                falseCaseExecutableItem.execute(slotIndex);
            }
        } else {
            throw new IfTypeErrorException("if instance must be NodeIfComponent");
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_IF;
    }

    public Executable getTrueCaseExecutableItem() {
        return this.getExecutableOne("IF_TRUE_CASE_KEY");
    }

    public void setTrueCaseExecutableItem(Executable trueCaseExecutableItem) {
        this.addExecutable("IF_TRUE_CASE_KEY", trueCaseExecutableItem);
    }

    public Executable getFalseCaseExecutableItem() {
        return this.getExecutableOne("IF_FALSE_CASE_KEY");
    }

    public void setFalseCaseExecutableItem(Executable falseCaseExecutableItem) {
        this.addExecutable("IF_FALSE_CASE_KEY", falseCaseExecutableItem);
    }

    public void setIfNode(Node ifNode) {
        this.addExecutable("IF_KEY", ifNode);
    }

    public Node getIfNode() {
        return (Node)this.getExecutableOne("IF_KEY");
    }
}

