/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Condition
implements Executable {
    private String id;
    private final Map<String, List<Executable>> executableGroup = new HashMap<String, List<Executable>>();
    private String currChainId;

    @Override
    public void execute(Integer slotIndex) throws Exception {
        try {
            this.executeCondition(slotIndex);
        }
        catch (ChainEndException e) {
            throw e;
        }
        catch (Exception e) {
            Slot slot = DataBus.getSlot(slotIndex);
            String chainId = this.getCurrChainId();
            if (slot.isSubChain(chainId)) {
                slot.setSubException(chainId, e);
            } else {
                slot.setException(e);
            }
            throw e;
        }
    }

    protected abstract void executeCondition(Integer var1) throws Exception;

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.CONDITION;
    }

    @Override
    public String getExecuteId() {
        return this.id;
    }

    public List<Executable> getExecutableList() {
        return this.getExecutableList("DEFAULT_KEY");
    }

    public List<Executable> getExecutableList(String groupKey) {
        List<Executable> executableList = this.executableGroup.get(groupKey);
        if (CollUtil.isEmpty(executableList)) {
            executableList = new ArrayList<Executable>();
        }
        return executableList;
    }

    public Executable getExecutableOne(String groupKey) {
        List<Executable> list = this.getExecutableList(groupKey);
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public void setExecutableList(List<Executable> executableList) {
        this.executableGroup.put("DEFAULT_KEY", executableList);
    }

    public void addExecutable(Executable executable) {
        this.addExecutable("DEFAULT_KEY", executable);
    }

    public void addExecutable(String groupKey, Executable executable) {
        if (ObjectUtil.isNull((Object)executable)) {
            return;
        }
        List<Executable> executableList = this.executableGroup.get(groupKey);
        if (CollUtil.isEmpty(executableList)) {
            this.executableGroup.put(groupKey, ListUtil.toList((Object[])new Executable[]{executable}));
        } else {
            this.executableGroup.get(groupKey).add(executable);
        }
    }

    public abstract ConditionTypeEnum getConditionType();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Deprecated
    public String getCurrChainName() {
        return this.currChainId;
    }

    public String getCurrChainId() {
        return this.currChainId;
    }

    @Override
    public void setCurrChainId(String currChainId) {
        this.currChainId = currChainId;
    }

    public Map<String, List<Executable>> getExecutableGroup() {
        return this.executableGroup;
    }
}

