/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.CatchErrorException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;

public class CatchCondition
extends Condition {
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            Executable catchExecutable = this.getCatchItem();
            if (ObjectUtil.isNull((Object)catchExecutable)) {
                String errorInfo = StrUtil.format((CharSequence)"[{}]:no catch item find", (Object[])new Object[]{slot.getRequestId()});
                throw new CatchErrorException(errorInfo);
            }
            catchExecutable.setCurrChainId(this.getCurrChainId());
            catchExecutable.execute(slotIndex);
        }
        catch (Exception e) {
            Executable doExecutable = this.getDoItem();
            if (ObjectUtil.isNotNull((Object)doExecutable)) {
                doExecutable.setCurrChainId(this.getCurrChainId());
                doExecutable.execute(slotIndex);
            }
            DataBus.getSlot(slotIndex).removeException();
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_CATCH;
    }

    public Executable getCatchItem() {
        return this.getExecutableOne("CATCH_KEY");
    }

    public void setCatchItem(Executable executable) {
        this.addExecutable("CATCH_KEY", executable);
    }

    public Executable getDoItem() {
        return this.getExecutableOne("DO_KEY");
    }

    public void setDoItem(Executable executable) {
        this.addExecutable("DO_KEY", executable);
    }
}

