/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.google.common.primitives.UnsignedLong;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.utils.checksum.CRC64;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.CheckedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);

    public static String getCRCValue(File file) {
        try {
            CheckedInputStream checkedInputStream = new CheckedInputStream(new FileInputStream(file), new CRC64());
            while (checkedInputStream.read() != -1) {
            }
            return UnsignedLong.fromLongBits((long)checkedInputStream.getChecksum().getValue()).toString();
        }
        catch (Exception ex) {
            throw new YopClientException("Exception occurred when get CRCVALUE for File:" + file.getName());
        }
    }
}

