/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class BeanUtils {
    public static <T> T merge(T sourceBean, T targetBean) {
        if (null == sourceBean) {
            return targetBean;
        }
        if (null == targetBean) {
            return sourceBean;
        }
        Class<?> sourceBeanClass = sourceBean.getClass();
        Class<?> targetBeanClass = targetBean.getClass();
        Field[] sourceFields = sourceBeanClass.getDeclaredFields();
        Field[] targetFields = targetBeanClass.getDeclaredFields();
        for (int i = 0; i < sourceFields.length; ++i) {
            Field targetField;
            Field sourceField = sourceFields[i];
            if (Modifier.isStatic(sourceField.getModifiers()) || Modifier.isStatic((targetField = targetFields[i]).getModifiers())) continue;
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            try {
                if (sourceField.get(sourceBean) == null || "serialVersionUID".equals(sourceField.getName())) continue;
                targetField.set(targetBean, sourceField.get(sourceBean));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return targetBean;
    }
}

