/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.request;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.model.BaseRequest;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class YopRequest
extends BaseRequest {
    private static final long serialVersionUID = -1L;
    private String apiUri;
    private String httpMethod;
    private final Multimap<String, String> parameters = ArrayListMultimap.create();
    private final Multimap<String, Object> multipartFiles = ArrayListMultimap.create();
    private Object content;

    public YopRequest(String apiUri, String httpMethod) {
        this.apiUri = apiUri;
        this.httpMethod = httpMethod;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Multimap<String, String> getParameters() {
        return this.parameters;
    }

    public Multimap<String, Object> getMultipartFiles() {
        return this.multipartFiles;
    }

    public Object getContent() {
        return this.content;
    }

    public YopRequest addParameter(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new YopClientException("parameter name:" + name + " should not be empty.");
        }
        if (value == null) {
            throw new YopClientException("parameter value for name:" + name + " can't be null.");
        }
        this.parameters.put((Object)name, (Object)value);
        return this;
    }

    public YopRequest addParameters(String name, List<String> values) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new YopClientException("parameter name:" + name + " should not be empty.");
        }
        if (values == null) {
            throw new YopClientException("parameter value for name:" + name + " can't be null.");
        }
        this.parameters.putAll((Object)name, values);
        return this;
    }

    public YopRequest addParameter(String name, Object value) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new YopClientException("parameter name:" + name + " should not be empty.");
        }
        if (value == null) {
            throw new YopClientException("parameter value for name:" + name + " can't be null.");
        }
        if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                if (o == null) continue;
                this.parameters.put((Object)name, (Object)o.toString());
            }
        } else if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(value, i);
                if (o == null) continue;
                this.parameters.put((Object)name, (Object)o.toString());
            }
        } else {
            this.parameters.put((Object)name, (Object)value.toString());
        }
        return this;
    }

    public YopRequest addMutiPartFile(String name, File file) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new YopClientException("parameter name:" + name + " should not be empty.");
        }
        if (file == null || !file.exists()) {
            throw new YopClientException("file is null or file does not exist.");
        }
        this.multipartFiles.put((Object)name, (Object)file);
        return this;
    }

    public YopRequest addMultiPartFile(String name, InputStream inputStream) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new YopClientException("parameter name:" + name + " should not be empty.");
        }
        if (inputStream == null) {
            throw new YopClientException("inputStream for name:" + name + " should not be null.");
        }
        this.multipartFiles.put((Object)name, (Object)inputStream);
        return this;
    }

    public YopRequest setContent(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            throw new YopClientException("content should not be empty");
        }
        this.content = content;
        return this;
    }

    public YopRequest setStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new YopClientException("inputStream for content should not be null");
        }
        this.content = inputStream;
        return this;
    }

    public YopRequest withApiUri(String apiUri) {
        this.apiUri = apiUri;
        return this;
    }

    public YopRequest withHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Override
    public String getOperationId() {
        return this.apiUri;
    }
}

