/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.security.aes;

import com.yeepay.yop.sdk.YopConstants;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AesEncryptor {
    private static final String AES_ALG = "AES";
    private static final String AES_CBC_PCK_ALG = "AES/CBC/PKCS5Padding";
    private static final byte[] AES_IV = AesEncryptor.initIv("AES/CBC/PKCS5Padding");

    public static byte[] encrypt(byte[] data, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(1, (Key)new SecretKeySpec(key, AES_ALG), iv);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AesEncryptor.initIv(AES_CBC_PCK_ALG));
            cipher.init(2, (Key)new SecretKeySpec(key, AES_ALG), iv);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("decrypt fail!", e);
        }
    }

    public static String encrypt(String data, String key) {
        try {
            byte[] valueByte = AesEncryptor.encrypt(data.getBytes(YopConstants.DEFAULT_CHARSET), Base64.decodeBase64((byte[])key.getBytes(YopConstants.DEFAULT_CHARSET)));
            return new String(Base64.encodeBase64((byte[])valueByte), YopConstants.DEFAULT_CHARSET);
        }
        catch (Throwable ex) {
            throw new RuntimeException("encrypt fail!", ex);
        }
    }

    public static String decrypt(String data, String key) {
        try {
            byte[] originalData = Base64.decodeBase64((byte[])data.getBytes(YopConstants.DEFAULT_CHARSET));
            byte[] valueByte = AesEncryptor.decrypt(originalData, Base64.decodeBase64((byte[])key.getBytes(YopConstants.DEFAULT_CHARSET)));
            return new String(valueByte, YopConstants.DEFAULT_CHARSET);
        }
        catch (Throwable ex) {
            throw new RuntimeException("decrypt fail!", ex);
        }
    }

    private static byte[] initIv(String fullAlg) {
        try {
            Cipher cipher = Cipher.getInstance(fullAlg);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }
}

