/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.security;

import com.google.common.base.Charsets;
import com.yeepay.yop.sdk.auth.credentials.YopRSACredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.exception.VerifySignFailedException;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.SymmetricEncryptAlgEnum;
import com.yeepay.yop.sdk.security.SymmetricEncryption;
import com.yeepay.yop.sdk.security.SymmetricEncryptionFactory;
import com.yeepay.yop.sdk.security.rsa.RSA;
import com.yeepay.yop.sdk.utils.Encodes;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;

public class DigitalEnvelopeUtils {
    private static final String SEPARATOR = "$";

    public static String decrypt(String cipherText, PrivateKey privateKey) {
        PublicKey publicKey;
        String signToBase64;
        String[] args = cipherText.split("\\$");
        if (args.length != 4) {
            throw new RuntimeException("source invalid : " + cipherText);
        }
        String encryptedRandomKeyToBase64 = args[0];
        String encryptedDataToBase64 = args[1];
        SymmetricEncryptAlgEnum symmetricEncryptAlg = SymmetricEncryptAlgEnum.parse(args[2]);
        DigestAlgEnum digestAlg = DigestAlgEnum.parse(args[3]);
        SymmetricEncryption symmetricEncryption = SymmetricEncryptionFactory.getSymmetricEncryption(symmetricEncryptAlg);
        byte[] randomKey = RSA.decrypt(Encodes.decodeBase64(encryptedRandomKeyToBase64), privateKey);
        byte[] encryptedData = symmetricEncryption.decrypt(Encodes.decodeBase64(encryptedDataToBase64), randomKey);
        String data = new String(encryptedData, Charsets.UTF_8);
        String sourceData = StringUtils.substringBeforeLast((String)data, (String)SEPARATOR);
        boolean verifySign = RSA.verifySign(sourceData, signToBase64 = StringUtils.substringAfterLast((String)data, (String)SEPARATOR), publicKey = DigitalEnvelopeUtils.getYopPublicKey(CertTypeEnum.RSA2048), digestAlg);
        if (!verifySign) {
            throw new YopClientException("verifySign fail!");
        }
        return sourceData;
    }

    private static PublicKey getYopPublicKey(CertTypeEnum certType) {
        YopSdkConfig yopSdkConfig = YopSdkConfigProviderRegistry.getProvider().getConfig();
        return yopSdkConfig.loadYopPublicKey(certType);
    }

    public static String decrypt(String cipherText, String credentialType) {
        return DigitalEnvelopeUtils.decrypt(cipherText, "default", credentialType);
    }

    public static String decrypt(String cipherText, String appKey, String credentialType) {
        YopRSACredentials yopCredentials = (YopRSACredentials)YopCredentialsProviderRegistry.getProvider().getCredentials(appKey, credentialType);
        PrivateKey privateKey = yopCredentials.getPrivateKey();
        return DigitalEnvelopeUtils.decrypt(cipherText, privateKey);
    }

    public static void verify(String content, String signature, PublicKey publicKey) {
        String[] args = signature.split("\\$");
        if (args.length != 2) {
            throw new VerifySignFailedException("Illegal format");
        }
        String signToBase64 = args[0];
        DigestAlgEnum digestAlg = DigestAlgEnum.parse(args[1]);
        boolean verifySign = RSA.verifySign(content.replaceAll("[ \t\n]", ""), signToBase64, publicKey, digestAlg);
        if (!verifySign) {
            throw new VerifySignFailedException("Unexpected signature");
        }
    }
}

