/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.protocol.marshaller;

import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.support.DateTimeMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.support.LocalDateMarshaller;
import java.util.HashMap;
import java.util.Map;

public class PrimitiveMarshallerUtils {
    private static final Map<String, PrimitiveMarshaller> MARSHALLERS = new HashMap<String, PrimitiveMarshaller>();

    public static <T> String marshalling(T param, String type) {
        if (param == null) {
            return null;
        }
        PrimitiveMarshaller marshaller = MARSHALLERS.get(type);
        if (marshaller == null) {
            return param.toString();
        }
        return marshaller.marshalling(param);
    }

    private static void register(PrimitiveMarshaller marshaller) {
        MARSHALLERS.put(marshaller.supportedType(), marshaller);
    }

    static {
        PrimitiveMarshallerUtils.register(new LocalDateMarshaller());
        PrimitiveMarshallerUtils.register(new DateTimeMarshaller());
    }
}

