/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.model;

import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import java.util.List;
import java.util.Map;

public class YopRequestConfig {
    private String appKey;
    private String securityReq;
    private YopCredentials credentials;
    private Map<String, String> customRequestHeaders;
    private Map<String, List<String>> customQueryParameters;
    private int readTimeout;
    private int connectTimeout;
    private Boolean needEncrypt;

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getSecurityReq() {
        return this.securityReq;
    }

    public void setSecurityReq(String securityReq) {
        this.securityReq = securityReq;
    }

    public YopCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(YopCredentials credentials) {
        this.credentials = credentials;
    }

    public Map<String, String> getCustomRequestHeaders() {
        return this.customRequestHeaders;
    }

    public void setCustomRequestHeaders(Map<String, String> customRequestHeaders) {
        this.customRequestHeaders = customRequestHeaders;
    }

    public Map<String, List<String>> getCustomQueryParameters() {
        return this.customQueryParameters;
    }

    public void setCustomQueryParameters(Map<String, List<String>> customQueryParameters) {
        this.customQueryParameters = customQueryParameters;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Boolean getNeedEncrypt() {
        return this.needEncrypt;
    }

    public void setNeedEncrypt(Boolean needEncrypt) {
        this.needEncrypt = needEncrypt;
    }

    public static final class Builder {
        private String appKey;
        private String securityReq;
        private YopCredentials credentials;
        private Map<String, String> customRequestHeaders;
        private Map<String, List<String>> customQueryParameters;
        private int readTimeout;
        private int connectTimeout;
        private Boolean needEncrypt;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder withAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder withSecurityReq(String securityReq) {
            this.securityReq = securityReq;
            return this;
        }

        public Builder withCredentials(YopCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder withCustomRequestHeaders(Map<String, String> customRequestHeaders) {
            this.customRequestHeaders = customRequestHeaders;
            return this;
        }

        public Builder withCustomQueryParameters(Map<String, List<String>> customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public Builder withRequestTimeout(Integer requestTimeout) {
            this.readTimeout = requestTimeout;
            return this;
        }

        public Builder withConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withNeedEncrypt(Boolean needEncrypt) {
            this.needEncrypt = needEncrypt;
            return this;
        }

        public YopRequestConfig build() {
            YopRequestConfig requestConfig = new YopRequestConfig();
            requestConfig.setAppKey(this.appKey);
            requestConfig.setSecurityReq(this.securityReq);
            requestConfig.setCredentials(this.credentials);
            requestConfig.setCustomRequestHeaders(this.customRequestHeaders);
            requestConfig.setCustomQueryParameters(this.customQueryParameters);
            requestConfig.setReadTimeout(this.readTimeout);
            requestConfig.setConnectTimeout(this.connectTimeout);
            requestConfig.setNeedEncrypt(this.needEncrypt);
            return requestConfig;
        }
    }
}

