/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopResponseMetadata;
import org.apache.commons.lang3.StringUtils;

public class YopSignatureCheckAnalyzer
implements HttpResponseAnalyzer {
    private static final YopSignatureCheckAnalyzer INSTANCE = new YopSignatureCheckAnalyzer();

    public static YopSignatureCheckAnalyzer getInstance() {
        return INSTANCE;
    }

    private YopSignatureCheckAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        YopResponseMetadata metadata = response.getMetadata();
        if (StringUtils.isNotEmpty((CharSequence)metadata.getYopSign())) {
            context.getSigner().checkSignature(context.getResponse(), metadata.getYopSign(), context.getYopPublicKey(), context.getSignOptions());
        }
        return false;
    }
}

