/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopResponseMetadata;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class YopContentDecryptAnalyzer
implements HttpResponseAnalyzer {
    private static final YopContentDecryptAnalyzer INSTANCE = new YopContentDecryptAnalyzer();
    private static final String CONTENT_TYPE_JSON = "application/json";

    public static YopContentDecryptAnalyzer getInstance() {
        return INSTANCE;
    }

    private YopContentDecryptAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        String content;
        YopResponseMetadata metadata = response.getMetadata();
        YopHttpResponse httpResponse = context.getResponse();
        if (BooleanUtils.isTrue((Boolean)context.isNeedDecrypt()) && this.isJsonResponse(metadata.getContentType()) && (content = httpResponse.readContent()) != null && !StringUtils.startsWith((CharSequence)content, (CharSequence)"{")) {
            String decryptedContent = context.getEncryptor().decrypt(content);
            httpResponse.setDecryptedContent(decryptedContent);
        }
        return false;
    }

    private boolean isJsonResponse(String contentType) {
        return StringUtils.startsWith((CharSequence)contentType, (CharSequence)CONTENT_TYPE_JSON);
    }
}

