/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.utils.DateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopHttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(YopHttpResponse.class);
    private final CloseableHttpResponse httpResponse;
    private final InputStream content;
    private String contentStr;

    public YopHttpResponse(CloseableHttpResponse httpResponse) throws IOException {
        this.httpResponse = httpResponse;
        HttpEntity entity = httpResponse.getEntity();
        this.content = entity != null && entity.isStreaming() ? entity.getContent() : null;
    }

    public String getHeader(String name) {
        Header header = this.httpResponse.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public long getHeaderAsLong(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            logger.warn("Invalid " + name + ":" + value, (Throwable)e);
            return -1L;
        }
    }

    public Date getHeaderAsRfc822Date(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.parseRfc822Date(value);
        }
        catch (Exception e) {
            logger.warn("Invalid " + name + ":" + value, (Throwable)e);
            return null;
        }
    }

    public InputStream getContent() {
        return this.content;
    }

    public String readContent() {
        if (this.contentStr != null) {
            return this.contentStr;
        }
        try {
            String string = this.contentStr = IOUtils.toString((InputStream)this.content, (String)"UTF-8");
            return string;
        }
        catch (IOException ex) {
            throw new YopClientException("unable to read response content", ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.content);
        }
    }

    public void setDecryptedContent(String decryptedContent) {
        this.contentStr = decryptedContent;
    }

    public String getStatusText() {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public CloseableHttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public Map<String, String> getHeaders() {
        HashMap headers = Maps.newHashMap();
        for (Header header : this.httpResponse.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }
}

