/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.google.common.base.Preconditions;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.ExecutionContext;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.IdleConnectionReaper;
import com.yeepay.yop.sdk.http.Protocol;
import com.yeepay.yop.sdk.http.RetryPolicy;
import com.yeepay.yop.sdk.internal.MultiPartFile;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.model.yos.YosDownloadResponse;
import com.yeepay.yop.sdk.utils.HttpUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopHttpClient {
    private static final Logger requestLogger = LoggerFactory.getLogger((String)"com.yeepay.yop.sdk.http");
    private static final Logger logger = LoggerFactory.getLogger(YopHttpClient.class);
    private final CloseableHttpClient httpClient;
    private final ClientConfiguration config;
    private final HttpClientConnectionManager connectionManager;
    private final RequestConfig defaultConfig;
    private CredentialsProvider credentialsProvider;
    private HttpHost proxyHttpHost;

    public YopHttpClient(ClientConfiguration config) {
        Preconditions.checkNotNull((Object)config, (Object)"config should not be null.");
        this.config = config;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(config.getConnectionTimeoutInMillis()).setConnectionRequestTimeout(config.getConnectionRequestTimeoutInMillis()).setSocketTimeout(config.getSocketTimeoutInMillis()).setStaleConnectionCheckEnabled(true);
        if (config.getLocalAddress() != null) {
            requestConfigBuilder.setLocalAddress(config.getLocalAddress());
        }
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            this.proxyHttpHost = new HttpHost(proxyHost, proxyPort, config.getProxyScheme());
            requestConfigBuilder.setProxy(this.proxyHttpHost);
            this.credentialsProvider = new BasicCredentialsProvider();
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
        this.connectionManager = this.createHttpClientConnectionManager();
        this.defaultConfig = requestConfigBuilder.build();
        this.httpClient = this.createHttpClient(this.connectionManager, this.defaultConfig);
        IdleConnectionReaper.registerConnectionManager(this.connectionManager);
    }

    public <Output extends BaseResponse, Input extends BaseRequest> Output execute(Request<Input> request, YopRequestConfig yopRequestConfig, ExecutionContext executionContext, HttpResponseHandler<Output> responseHandler) {
        Output Output;
        YopCredentials yopCredentials = executionContext.getYopCredentials();
        this.setAppKey(request, yopCredentials);
        this.setUserAgent(request);
        CloseableHttpResponse httpResponse = null;
        Output yopResponse = null;
        try {
            if (BooleanUtils.isTrue((Boolean)yopRequestConfig.getNeedEncrypt())) {
                this.encryptRequest(request, executionContext);
            }
            this.signRequest(request, executionContext);
            requestLogger.debug("Sending Request: {}", request);
            HttpRequestBase httpRequest = this.createHttpRequest(request);
            HttpClientContext httpContext = this.createHttpContext(request, yopRequestConfig);
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
            HttpUtils.printRequest(httpRequest);
            Output = yopResponse = (Output)responseHandler.handle(new HttpResponseHandleContext(httpResponse, request, yopRequestConfig, executionContext));
        }
        catch (Exception e) {
            try {
                YopClientException yop = e instanceof YopClientException ? (YopClientException)e : new YopClientException("Unable to execute HTTP request", e);
                throw yop;
            }
            catch (Throwable throwable) {
                if (!(yopResponse instanceof YosDownloadResponse)) {
                    HttpClientUtils.closeQuietly(httpResponse);
                }
                throw throwable;
            }
        }
        if (!(yopResponse instanceof YosDownloadResponse)) {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
        }
        return Output;
    }

    private <Input extends BaseRequest> void encryptRequest(Request<Input> request, ExecutionContext executionContext) {
        executionContext.getEncryptor().encrypt(request);
    }

    private <Input extends BaseRequest> void signRequest(Request<Input> request, ExecutionContext executionContext) {
        executionContext.getSigner().sign(request, executionContext.getYopCredentials(), executionContext.getSignOptions());
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        SSLConnectionSocketFactory sslSocketFactory;
        PlainConnectionSocketFactory socketFactory = PlainConnectionSocketFactory.getSocketFactory();
        try {
            SSLContext s;
            String javaVersion = System.getProperty("java.version");
            String tlsVersion = null;
            if (StringUtils.startsWith((CharSequence)javaVersion, (CharSequence)"1.8") || StringUtils.startsWith((CharSequence)javaVersion, (CharSequence)"1.7")) {
                tlsVersion = "TLSv1.2";
            } else if (StringUtils.startsWith((CharSequence)javaVersion, (CharSequence)"1.6")) {
                tlsVersion = "TLSv1.1";
            }
            if (StringUtils.isNotEmpty((CharSequence)tlsVersion)) {
                s = SSLContext.getInstance(tlsVersion);
                s.init(null, null, null);
            } else {
                s = SSLContext.getDefault();
            }
            sslSocketFactory = new SSLConnectionSocketFactory(s, SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new YopClientException("Fail to create SSLConnectionSocketFactory", e);
        }
        Registry registry = RegistryBuilder.create().register(Protocol.HTTP.toString(), (Object)socketFactory).register(Protocol.HTTPS.toString(), (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.config.getSocketTimeoutInMillis()).setTcpNoDelay(true).build());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        connectionManager.setValidateAfterInactivity(3000);
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager, RequestConfig requestConfig) {
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(connectionManager).disableAutomaticRetries();
        int socketBufferSizeInBytes = this.config.getSocketBufferSizeInBytes();
        if (socketBufferSizeInBytes > 0) {
            builder.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(socketBufferSizeInBytes).build());
        }
        return builder.setDefaultRequestConfig(requestConfig).build();
    }

    protected HttpClientContext createHttpContext(Request<? extends BaseRequest> request, YopRequestConfig yopRequestConfig) {
        HttpClientContext context = HttpClientContext.create();
        if (yopRequestConfig.getConnectTimeout() > 0 || yopRequestConfig.getReadTimeout() > 0) {
            RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)this.defaultConfig);
            if (yopRequestConfig.getConnectTimeout() > 0) {
                requestConfigBuilder.setConnectTimeout(yopRequestConfig.getConnectTimeout());
            }
            if (yopRequestConfig.getReadTimeout() > 0) {
                requestConfigBuilder.setSocketTimeout(yopRequestConfig.getReadTimeout());
            }
            context.setRequestConfig(requestConfigBuilder.build());
        }
        if (this.credentialsProvider != null) {
            context.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.config.isProxyPreemptiveAuthenticationEnabled()) {
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(this.proxyHttpHost, (AuthScheme)new BasicScheme());
            context.setAuthCache((AuthCache)authCache);
        }
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpRequestBase createHttpRequest(Request<?> request) throws UnsupportedEncodingException {
        HttpPost httpRequest;
        boolean isMultiPart;
        String uri = HttpUtils.appendUri(request.getEndpoint(), request.getResourcePath()).toASCIIString();
        boolean bl = isMultiPart = request.getMultiPartFiles() != null && request.getMultiPartFiles().size() > 0;
        if (isMultiPart) {
            String name;
            HttpPost postMethod;
            if (request.getHttpMethod() != HttpMethodName.POST) throw new YopClientException("ContentType:multipart/form-data only support Post Request");
            httpRequest = postMethod = new HttpPost(uri);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (Map.Entry<String, List<String>> entry : request.getParameters().entrySet()) {
                name = entry.getKey();
                for (String string : entry.getValue()) {
                    builder.addTextBody(HttpUtils.normalize(name), HttpUtils.normalize(string));
                }
            }
            for (Map.Entry<String, List<Object>> entry : request.getMultiPartFiles().entrySet()) {
                name = entry.getKey();
                for (MultiPartFile multiPartFile : entry.getValue()) {
                    builder.addBinaryBody(name, (InputStream)multiPartFile.getInputStream(), ContentType.DEFAULT_BINARY, multiPartFile.getFileName());
                }
            }
            postMethod.setEntity(builder.build());
        } else {
            boolean bl2;
            String encodedParams = HttpUtils.encodeParameters(request, false);
            boolean requestHasPayload = request.getContent() != null;
            boolean requestIsPost = request.getHttpMethod() == HttpMethodName.POST;
            boolean bl3 = bl2 = !requestIsPost || requestHasPayload;
            if (encodedParams != null && bl2) {
                uri = uri + "?" + encodedParams;
            }
            long contentLength = -1L;
            String string = request.getHeaders().get("Content-Length");
            if (string != null) {
                contentLength = Long.parseLong(string);
            }
            if (request.getHttpMethod() == HttpMethodName.GET) {
                httpRequest = new HttpGet(uri);
            } else if (request.getHttpMethod() == HttpMethodName.PUT) {
                HttpPut putMethod = new HttpPut(uri);
                httpRequest = putMethod;
                if (request.getContent() != null) {
                    putMethod.setEntity((HttpEntity)new InputStreamEntity(request.getContent(), contentLength));
                }
            } else if (request.getHttpMethod() == HttpMethodName.POST) {
                HttpPost postMethod;
                httpRequest = postMethod = new HttpPost(uri);
                if (request.getContent() != null) {
                    postMethod.setEntity((HttpEntity)new InputStreamEntity(request.getContent(), contentLength));
                } else if (encodedParams != null) {
                    postMethod.setEntity((HttpEntity)new StringEntity(encodedParams));
                }
            } else if (request.getHttpMethod() == HttpMethodName.DELETE) {
                httpRequest = new HttpDelete(uri);
            } else {
                if (request.getHttpMethod() != HttpMethodName.HEAD) throw new YopClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
                httpRequest = new HttpHead(uri);
            }
        }
        httpRequest.addHeader("Host", HttpUtils.generateHostHeader(request.getEndpoint()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (isMultiPart) return httpRequest;
        Preconditions.checkNotNull((Object)httpRequest.getFirstHeader("Content-Type"), (Object)"Content-Type not set");
        return httpRequest;
    }

    protected long getDelayBeforeNextRetryInMillis(HttpRequestBase method, YopClientException exception, int attempt, RetryPolicy retryPolicy) {
        HttpEntity entity;
        int retries = attempt - 1;
        int maxErrorRetry = retryPolicy.getMaxErrorRetry();
        if (retries >= maxErrorRetry) {
            return -1L;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            logger.debug("Entity not repeatable, stop retrying");
            return -1L;
        }
        return Math.min(retryPolicy.getMaxDelayInMillis(), retryPolicy.getDelayBeforeNextRetryInMillis(exception, retries));
    }

    private void setUserAgent(Request<? extends BaseRequest> request) {
        request.addHeader("User-Agent", this.config.getUserAgent());
    }

    private void setAppKey(Request<? extends BaseRequest> request, YopCredentials yopCredentials) {
        request.addHeader("x-yop-appkey", yopCredentials.getAppKey());
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }
}

