/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.google.common.base.Preconditions;
import com.yeepay.yop.sdk.ErrorCode;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.exception.YopServiceException;
import com.yeepay.yop.sdk.http.RetryPolicy;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRetryPolicy
implements RetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRetryPolicy.class);
    private static final int SCALE_FACTOR = 300;
    private final int maxErrorRetry;
    private final long maxDelayInMillis;

    public DefaultRetryPolicy() {
        this(3, 20000L);
    }

    public DefaultRetryPolicy(int maxErrorRetry, long maxDelayInMillis) {
        Preconditions.checkArgument((maxErrorRetry >= 0 ? 1 : 0) != 0, (Object)"maxErrorRetry should be a non-negative.");
        Preconditions.checkArgument((maxDelayInMillis >= 0L ? 1 : 0) != 0, (Object)"maxDelayInMillis should be a non-negative.");
        this.maxErrorRetry = maxErrorRetry;
        this.maxDelayInMillis = maxDelayInMillis;
    }

    @Override
    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    @Override
    public long getMaxDelayInMillis() {
        return this.maxDelayInMillis;
    }

    @Override
    public long getDelayBeforeNextRetryInMillis(YopClientException exception, int retriesAttempted) {
        if (!this.shouldRetry(exception, retriesAttempted)) {
            return -1L;
        }
        if (retriesAttempted < 0) {
            return 0L;
        }
        return (1 << retriesAttempted + 1) * 300;
    }

    protected boolean shouldRetry(YopClientException exception, int retriesAttempted) {
        if (exception.getCause() instanceof IOException) {
            logger.debug("Retry for IOException.");
            return true;
        }
        if (exception instanceof YopServiceException) {
            YopServiceException e = (YopServiceException)exception;
            if (e.getStatusCode() == 500) {
                logger.debug("Retry for internal server error.");
                return true;
            }
            if (e.getStatusCode() == 502) {
                logger.debug("Retry for bad gateway.");
                return true;
            }
            if (e.getStatusCode() == 503) {
                logger.debug("Retry for service unavailable.");
                return true;
            }
            String errorCode = e.getErrorCode();
            if (ErrorCode.REQUEST_EXPIRED.equals(errorCode)) {
                logger.debug("Retry for request expired.");
                return true;
            }
        }
        return false;
    }
}

