/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.config.provider.file;

import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.YopFixedSdkConfigProvider;
import com.yeepay.yop.sdk.config.provider.file.YopFileSdkConfig;
import com.yeepay.yop.sdk.utils.BeanUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class YopFileSdkConfigProvider
extends YopFixedSdkConfigProvider {
    private static final String SDK_CONFIG_FILE_PROPERTY_KEY = "yop.sdk.config.file";
    private static final String SDK_CONFIG_DIR = "config";
    private static final String DEFAULT_SDK_CONFIG_FILE_NAME = "yop_sdk_config_default.json";
    private YopFileSdkConfig loadedSdkConfig;

    @Override
    protected YopSdkConfig loadSdkConfig() {
        return this.convertYopSdkConfig(this.loadYopFileSdkConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public YopFileSdkConfig loadYopFileSdkConfig() {
        if (null != this.loadedSdkConfig) return this.loadedSdkConfig;
        Class<YopFileSdkConfigProvider> clazz = YopFileSdkConfigProvider.class;
        synchronized (YopFileSdkConfigProvider.class) {
            if (null != this.loadedSdkConfig) return this.loadedSdkConfig;
            String configFile = "config/yop_sdk_config_default.json";
            this.logger.info("\u52a0\u8f7d\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6{}", (Object)configFile);
            this.loadedSdkConfig = YopFileSdkConfigProvider.loadSdkConfig(configFile);
            configFile = System.getProperty(SDK_CONFIG_FILE_PROPERTY_KEY);
            if (!StringUtils.isNotEmpty((CharSequence)configFile)) return this.loadedSdkConfig;
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.file\uff0c\u5c1d\u8bd5\u4ece{}\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6", (Object)configFile);
            YopFileSdkConfig customSdkConfig = YopFileSdkConfigProvider.loadSdkConfig(configFile);
            this.loadedSdkConfig = BeanUtils.merge(customSdkConfig, this.loadedSdkConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.loadedSdkConfig;
        }
    }

    public static YopFileSdkConfig loadSdkConfig(String configFile) {
        YopFileSdkConfig sdkConfig = null;
        try {
            if (!StringUtils.startsWithAny((CharSequence)configFile, (CharSequence[])new CharSequence[]{"file://"})) {
                configFile = "classpath*:" + configFile;
            }
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(configFile);
            for (int i = resources.length - 1; i >= 0; --i) {
                Resource resource = resources[i];
                StringBuilder script = new StringBuilder();
                try (InputStreamReader isr = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
                     BufferedReader bufferReader = new BufferedReader(isr);){
                    String tempString;
                    while ((tempString = bufferReader.readLine()) != null) {
                        script.append(tempString).append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (script.length() <= 0) continue;
                YopFileSdkConfig sdkConfig0 = JsonUtils.loadFrom(script.toString(), YopFileSdkConfig.class);
                sdkConfig = BeanUtils.merge(sdkConfig0, sdkConfig);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sdkConfig;
    }

    private YopSdkConfig convertYopSdkConfig(YopFileSdkConfig yopFileSdkConfig) {
        YopSdkConfig yopSdkConfig = new YopSdkConfig();
        yopSdkConfig.setServerRoot(yopFileSdkConfig.getServerRoot());
        yopSdkConfig.setYosServerRoot(yopFileSdkConfig.getYosServerRoot());
        yopSdkConfig.setSandboxServerRoot(yopFileSdkConfig.getSandboxServerRoot());
        yopSdkConfig.setTrustAllCerts(yopFileSdkConfig.getTrustAllCerts());
        yopSdkConfig.setProxy(yopFileSdkConfig.getProxy());
        yopSdkConfig.setRegion(yopFileSdkConfig.getRegion());
        yopSdkConfig.setYopHttpClientConfig(yopFileSdkConfig.getHttpClient());
        yopSdkConfig.storeYopPublicKey(yopFileSdkConfig.getYopPublicKey());
        return yopSdkConfig;
    }
}

