/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.signer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.Signer;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopCredentialsWithoutSign;
import com.yeepay.yop.sdk.auth.credentials.YopRSACredentials;
import com.yeepay.yop.sdk.exception.VerifySignFailedException;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.rsa.RSA;
import com.yeepay.yop.sdk.utils.DateUtils;
import com.yeepay.yop.sdk.utils.Encodes;
import com.yeepay.yop.sdk.utils.HttpUtils;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaSigner
implements Signer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RsaSigner.class);
    private static final ThreadLocal<MessageDigest> SHA256_MESSAGE_DIGEST;
    private static final String YOP_AUTH_VERSION = "yop-auth-v3";
    private static final String SEPARATOR = "$";
    private static final Set<String> defaultHeadersToSign;
    private static final Joiner headerJoiner;
    private static final Joiner signedHeaderStringJoiner;

    @Override
    public void sign(Request<? extends BaseRequest> request, YopCredentials credentials, SignOptions options) {
        Preconditions.checkNotNull(request, (Object)"request should not be null.");
        if (credentials == null || credentials instanceof YopCredentialsWithoutSign) {
            return;
        }
        if (!(credentials instanceof YopRSACredentials)) {
            throw new YopClientException("UnSupported credentials type:" + credentials.getClass().getSimpleName());
        }
        YopRSACredentials rsaCredentials = (YopRSACredentials)credentials;
        String accessKeyId = credentials.getAppKey();
        request.addHeader("Host", HttpUtils.generateHostHeader(request.getEndpoint()));
        Date timestamp = new Date();
        String contentSha256 = this.calculateContentHash(request);
        request.addHeader("x-yop-content-sha256", contentSha256);
        String canonicalQueryString = this.getCanonicalQueryString(request);
        SortedMap<String, String> headersToSign = this.getHeadersToSign(request.getHeaders(), defaultHeadersToSign);
        String canonicalHeader = this.getCanonicalHeaders(headersToSign);
        String signedHeaders = signedHeaderStringJoiner.join(headersToSign.keySet());
        signedHeaders = signedHeaders.trim().toLowerCase();
        String authString = "yop-auth-v3/" + accessKeyId + "/" + DateUtils.formatAlternateIso8601Date(timestamp) + "/" + options.getExpirationInSeconds();
        String apiUri = request.getResourcePath();
        String canonicalURI = this.getCanonicalURIPath(apiUri);
        String canonicalRequest = authString + "\n" + (Object)((Object)request.getHttpMethod()) + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeader;
        String signature = this.computeSignature(canonicalRequest, rsaCredentials.getPrivateKey(), options.getDigestAlg());
        String authorizationHeader = options.getProtocolPrefix() + " " + authString + "/" + signedHeaders + "/" + signature;
        LOGGER.debug("CanonicalRequest:{}\tAuthorization:{}", (Object)canonicalRequest.replace("\n", "[\\n]"), (Object)authorizationHeader);
        request.addHeader("Authorization", authorizationHeader);
    }

    @Override
    public void checkSignature(YopHttpResponse httpResponse, String signature, PublicKey publicKey, SignOptions options) {
        String content = httpResponse.readContent();
        if (!RSA.verifySign(content = content.replaceAll("[ \t\n]", ""), signature, publicKey, options.getDigestAlg())) {
            throw new VerifySignFailedException("response sign verify failure");
        }
    }

    private String getCanonicalQueryString(Request<? extends BaseRequest> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            return "";
        }
        return HttpUtils.getCanonicalQueryString(request.getParameters(), true);
    }

    private String calculateContentHash(Request<? extends BaseRequest> request) {
        RestartableInputStream payloadStream = this.getBinaryRequestPayloadStream(request);
        String contentSha256 = Encodes.encodeHex(this.hash(payloadStream));
        payloadStream.restart();
        return contentSha256;
    }

    private byte[] hash(InputStream input) {
        try {
            MessageDigest md = RsaSigner.getMessageDigestInstance();
            DigestInputStream digestInputStream = new DigestInputStream(input, md);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new YopClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    private RestartableInputStream getBinaryRequestPayloadStream(Request<? extends BaseRequest> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = HttpUtils.getCanonicalQueryString(request.getParameters(), true);
            if (StringUtils.isEmpty((CharSequence)encodedParameters)) {
                return RestartableInputStream.wrap(new byte[0]);
            }
            return RestartableInputStream.wrap(encodedParameters.getBytes(YopConstants.DEFAULT_CHARSET));
        }
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
    }

    private RestartableInputStream getBinaryRequestPayloadStreamWithoutQueryParams(Request<? extends BaseRequest> request) {
        if (request.getContent() instanceof RestartableInputStream) {
            return (RestartableInputStream)request.getContent();
        }
        return RestartableInputStream.wrap(new byte[0]);
    }

    private String getCanonicalURIPath(String path) {
        if (path == null) {
            return "/";
        }
        if (path.startsWith("/")) {
            return HttpUtils.normalizePath(path);
        }
        return "/" + HttpUtils.normalizePath(path);
    }

    private SortedMap<String, String> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet tempSet = Sets.newHashSet();
            for (String header : headersToSign) {
                tempSet.add(header.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty() || headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key)) continue;
            ret.put(key, entry.getValue());
        }
        return ret;
    }

    private String getCanonicalHeaders(SortedMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList headerStrings = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(HttpUtils.normalize(key.trim().toLowerCase()) + ':' + HttpUtils.normalize(value.trim()));
        }
        Collections.sort(headerStrings);
        return headerJoiner.join((Iterable)headerStrings);
    }

    private String computeSignature(String content, PrivateKey signingKey, DigestAlgEnum digestAlg) {
        return RSA.sign(content, signingKey, digestAlg) + SEPARATOR + digestAlg.getValue();
    }

    private static MessageDigest getMessageDigestInstance() {
        MessageDigest messageDigest = SHA256_MESSAGE_DIGEST.get();
        messageDigest.reset();
        return messageDigest;
    }

    static {
        defaultHeadersToSign = Sets.newHashSet();
        headerJoiner = Joiner.on((char)'\n');
        signedHeaderStringJoiner = Joiner.on((char)';');
        defaultHeadersToSign.add("Content-Length".toLowerCase());
        defaultHeadersToSign.add("Content-Type".toLowerCase());
        defaultHeadersToSign.add("Content-MD5".toLowerCase());
        defaultHeadersToSign.add("x-yop-request-id");
        defaultHeadersToSign.add("x-yop-date");
        defaultHeadersToSign.add("x-yop-appkey");
        defaultHeadersToSign.add("x-yop-content-sha256");
        defaultHeadersToSign.add("x-yop-hash-crc64ecma");
        SHA256_MESSAGE_DIGEST = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new YopClientException("Unable to get SHA256 Function" + e.getMessage(), e);
                }
            }
        };
    }
}

