/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.signer;

import com.google.common.base.Preconditions;
import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.Signer;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopCredentialsWithoutSign;
import com.yeepay.yop.sdk.auth.credentials.YopOauth2Credentials;
import com.yeepay.yop.sdk.exception.VerifySignFailedException;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.security.rsa.RSA;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2Signer
implements Signer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Oauth2Signer.class);
    private static final String AUTHORIZATION_PREFIX = "Bearer ";

    @Override
    public void sign(Request<? extends BaseRequest> request, YopCredentials credentials, SignOptions options) {
        Preconditions.checkNotNull(request, (Object)"request should not be null.");
        if (credentials == null || credentials instanceof YopCredentialsWithoutSign) {
            return;
        }
        if (!(credentials instanceof YopOauth2Credentials)) {
            throw new YopClientException("UnSupported credentials type:" + credentials.getClass().getSimpleName());
        }
        String authorizationHeader = AUTHORIZATION_PREFIX + credentials.getSecretKey();
        request.addHeader("Authorization", authorizationHeader);
    }

    @Override
    public void checkSignature(YopHttpResponse httpResponse, String signature, PublicKey publicKey, SignOptions options) {
        String content = httpResponse.readContent();
        if (!RSA.verifySign(content = content.replaceAll("[ \t\n]", ""), signature, publicKey, options.getDigestAlg())) {
            throw new VerifySignFailedException("response sign verify failure");
        }
    }
}

