/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.credentials.provider;

import com.yeepay.yop.sdk.auth.credentials.YopAESCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopRSACredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.config.YopAppConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopBaseCredentialsProvider
implements YopCredentialsProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected final YopCredentials buildCredentials(YopAppConfig appConfig, String credentialType) {
        if (appConfig == null) {
            return null;
        }
        CertTypeEnum certType = CertTypeEnum.parse(credentialType);
        if (certType.isSymmetric()) {
            return new YopAESCredentials(appConfig.getAppKey(), appConfig.getAesSecretKey());
        }
        return new YopRSACredentials(appConfig.getAppKey(), (RSAPrivateKey)appConfig.loadPrivateKey(certType), appConfig.getEncryptKey());
    }
}

