/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log.event;

import com.yahoo.log.LogLevel;
import com.yahoo.log.event.Count;
import com.yahoo.log.event.Crash;
import com.yahoo.log.event.MalformedEventException;
import com.yahoo.log.event.Progress;
import com.yahoo.log.event.Started;
import com.yahoo.log.event.Starting;
import com.yahoo.log.event.State;
import com.yahoo.log.event.Stopped;
import com.yahoo.log.event.Stopping;
import com.yahoo.log.event.Unknown;
import com.yahoo.log.event.Value;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Event
implements Serializable {
    private static Logger log = Logger.getLogger(Event.class.getName());
    private static final int INITIAL = 0;
    private static final int IN_NAME = 1;
    private static final int IN_UNQUOTED = 2;
    private static final int IN_QUOTED = 3;
    private static final int EQUALS = 4;
    private static Pattern whitespace = Pattern.compile("\\s");
    private static Pattern eventFmt = Pattern.compile("^([^/]+)/(\\d+)(.*)$");
    private static String packageName = Event.class.getPackage().getName();
    private Map<String, String> values = new LinkedHashMap<String, String>(5);
    private int version = 1;
    private long time = -1L;

    protected Event() {
    }

    public Event setValue(String name, String value) {
        this.values.put(name, value);
        return this;
    }

    public String getValue(String name) {
        return this.values.get(name);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public Event setVersion(int version) {
        this.version = version;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public String getValuePossiblyQuote(String name) {
        String tmp = this.values.get(name);
        if (tmp == null) {
            return "";
        }
        Matcher m = whitespace.matcher(tmp);
        if (m.find()) {
            return new StringBuffer(tmp.length() + 2).append("\"").append(tmp).append("\"").toString();
        }
        return tmp;
    }

    public String getName() {
        String tmp = this.getClass().getName();
        int last = tmp.lastIndexOf(".");
        if (last == -1) {
            return tmp.toLowerCase();
        }
        return tmp.substring(last + 1).toLowerCase();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(128).append(this.getName()).append("/").append(this.version);
        for (String name : this.values.keySet()) {
            buff.append(" ").append(name).append("=").append(this.getValuePossiblyQuote(name));
        }
        return buff.toString();
    }

    private static void parseValuePairs(String s, Event event) {
        int i;
        int state = 0;
        int mark = 0;
        String name = null;
        block11: for (i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case ' ': {
                    if (state == 2) {
                        state = 0;
                        event.setValue(name, s.substring(mark, i));
                    }
                    if (state == 0) {
                        mark = -1;
                        continue block11;
                    }
                    if (state == 3) continue block11;
                    throw new IllegalStateException("space not allowed at " + i);
                }
                case '=': {
                    if (state == 1) {
                        name = s.substring(mark, i);
                        state = 4;
                        continue block11;
                    }
                    if (state == 3) continue block11;
                    throw new IllegalStateException("'=' not allowed at " + i);
                }
                case '\"': {
                    if (state == 4) {
                        state = 3;
                        mark = i;
                        continue block11;
                    }
                    if (state == 3) {
                        if (s.charAt(i - 1) == '\\') continue block11;
                        event.setValue(name, s.substring(mark + 1, i));
                        state = 0;
                        continue block11;
                    }
                    throw new IllegalStateException("'\"' not allowed at " + i);
                }
                default: {
                    if (state == 0) {
                        state = 1;
                        mark = i;
                        continue block11;
                    }
                    if (state != 4) continue block11;
                    state = 2;
                    mark = i;
                }
            }
        }
        switch (state) {
            case 2: {
                event.setValue(name, s.substring(mark, i));
                break;
            }
            case 3: {
                event.setValue(name, s.substring(mark + 1, i));
                break;
            }
            case 1: {
                throw new IllegalStateException("ended in name");
            }
            case 4: {
                event.setValue(name, null);
            }
        }
    }

    public static Event parse(String s) throws MalformedEventException {
        Event event;
        Matcher m1 = eventFmt.matcher(s);
        if (!m1.matches()) {
            throw new MalformedEventException(s);
        }
        String eventName = m1.group(1);
        String eventVersion = m1.group(2);
        String rest = m1.group(3);
        String className = new StringBuffer(eventName.length() + packageName.length() + 1).append(packageName).append(".").append(eventName.substring(0, 1).toUpperCase()).append(eventName.substring(1).toLowerCase()).toString();
        try {
            event = (Event)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            event = new Unknown().setName(eventName);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Event instantiation problem", e);
            return null;
        }
        event.setVersion(Integer.parseInt(eventVersion));
        try {
            Event.parseValuePairs(rest, event);
        }
        catch (IllegalStateException | NumberFormatException e) {
            throw new MalformedEventException(e);
        }
        return event;
    }

    private static final Logger getCallerLogger() {
        StackTraceElement frame;
        String cname;
        int i;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (i = 0; i < stack.length && !(cname = (frame = stack[i]).getClassName()).equals("com.yahoo.log.event.Event"); ++i) {
        }
        while (i < stack.length) {
            frame = stack[i];
            cname = frame.getClassName();
            if (!cname.equals("com.yahoo.log.event.Event")) {
                return Logger.getLogger(cname);
            }
            ++i;
        }
        return Logger.getLogger("");
    }

    private static final void log(Logger logger, Object param) {
        LogRecord r = new LogRecord(LogLevel.EVENT, null);
        r.setParameters(new Object[]{param});
        r.setLoggerName(logger.getName());
        logger.log(r);
    }

    public static final void starting(String name) {
        Event.log(Event.getCallerLogger(), new Starting(name));
    }

    public static final void started(String name) {
        Event.log(Event.getCallerLogger(), new Started(name));
    }

    public static final void stopping(String name, String why) {
        Event.log(Event.getCallerLogger(), new Stopping(name, why));
    }

    public static final void stopped(String name, int pid, int exitcode) {
        Event.log(Event.getCallerLogger(), new Stopped(name, pid, exitcode));
    }

    public static final void count(String name, long value) {
        Event.log(Event.getCallerLogger(), new Count(name, value));
    }

    public static final void value(String name, double value) {
        Event.log(Event.getCallerLogger(), new Value(name, value));
    }

    public static final void progress(String name, long value, long total) {
        Event.log(Event.getCallerLogger(), new Progress(name, value, total));
    }

    public static final void state(String name, String value) {
        Event.log(Event.getCallerLogger(), new State(name, value));
    }

    public static final void crash(String name, int pid, int signal) {
        Event.log(Event.getCallerLogger(), new Crash(name, pid, signal));
    }
}

