/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.FileLogTarget;
import com.yahoo.log.LogTarget;
import com.yahoo.log.StderrLogTarget;
import com.yahoo.log.StdoutLogTarget;
import com.yahoo.log.VespaFormatter;
import com.yahoo.log.VespaLevelControllerRepo;
import com.yahoo.log.VespaLogHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Timer;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogSetup {
    private static final Timer taskRunner = new Timer(true);
    private static VespaLogHandler logHandler;
    private static ZooKeeperFilter zooKeeperFilter;
    private static boolean isInitialized;

    static Timer getTaskRunner() {
        return taskRunner;
    }

    public static void clearHandlers() {
        Enumeration<String> names = LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            Handler[] handlers;
            String name = names.nextElement();
            Logger logger = Logger.getLogger(name);
            for (Handler handler : handlers = logger.getHandlers()) {
                logger.removeHandler(handler);
            }
        }
    }

    public static void initVespaLogging(String programName) {
        if (isInitialized) {
            System.err.println("WARNING: initVespaLogging called twice");
        }
        isInitialized = true;
        String logLevel = System.getProperty("vespa.log.level");
        String logTarget = System.getProperty("vespa.log.target");
        String logService = System.getProperty("vespa.service.name");
        String logControlDir = System.getProperty("vespa.log.control.dir");
        Object logControlFile = System.getProperty("vespa.log.control.file");
        if (programName == null || programName.equals("")) {
            throw new RuntimeException("invalid programName: " + programName);
        }
        if (logTarget == null) {
            logTarget = System.getenv("VESPA_LOG_TARGET");
        }
        if (logService == null) {
            logService = System.getenv("VESPA_SERVICE_NAME");
        }
        if (logControlDir == null) {
            logControlDir = System.getenv("VESPA_LOG_CONTROL_DIR");
        }
        if (logControlFile == null) {
            logControlFile = System.getenv("VESPA_LOG_CONTROL_FILE");
        }
        if (logLevel == null) {
            logLevel = System.getenv("VESPA_LOG_LEVEL");
        }
        if (logTarget == null) {
            logTarget = "fd:2";
        }
        if (logLevel == null) {
            logLevel = "all -debug -spam";
        }
        if (logControlFile == null && logControlDir != null && logService != null && !logService.equals("") && !logService.equals("-")) {
            logControlFile = logControlDir + "/" + logService + ".logcontrol";
        }
        if (logService == null) {
            logService = System.getProperty("config.id");
        }
        if (logService == null) {
            logService = "-";
        }
        System.setProperty("vespa.service.name", logService);
        System.setProperty("vespa.program.name", programName);
        try {
            LogSetup.initInternal(logTarget, logService, (String)logControlFile, programName, logLevel);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to initialize logging", e);
        }
    }

    private static LogTarget getLogTargetFromString(String target) throws FileNotFoundException {
        if ("fd:2".equals(target)) {
            return new StderrLogTarget();
        }
        if ("fd:1".equals(target)) {
            return new StdoutLogTarget();
        }
        if (target.startsWith("file:")) {
            return new FileLogTarget(new File(target.substring(5)));
        }
        throw new IllegalArgumentException("Target '" + target + "' is not a valid target");
    }

    private static void initInternal(String target, String service, String logCtlFn, String app, String lev) throws FileNotFoundException {
        LogSetup.clearHandlers();
        if (app != null && app.length() > 64) {
            app = app.substring(0, 63);
        }
        if (logHandler != null) {
            logHandler.cleanup();
            Logger.getLogger("").removeHandler(logHandler);
        }
        Logger.getLogger("").setLevel(Level.ALL);
        logHandler = new VespaLogHandler(LogSetup.getLogTargetFromString(target), new VespaLevelControllerRepo(logCtlFn, lev, app), service, app);
        String zookeeperLogFile = System.getProperty("zookeeper_log_file_prefix");
        if (zookeeperLogFile != null) {
            zooKeeperFilter = new ZooKeeperFilter(zookeeperLogFile);
            logHandler.setFilter(zooKeeperFilter);
        }
        Logger.getLogger("").addHandler(logHandler);
    }

    static VespaLogHandler getLogHandler() {
        return logHandler;
    }

    public static void cleanup() {
        if (zooKeeperFilter != null) {
            zooKeeperFilter.close();
        }
    }

    static {
        zooKeeperFilter = null;
        isInitialized = false;
    }

    static class ZooKeeperFilter
    implements Filter {
        private static final int FILE_SIZE = 0xA00000;
        private static final int maxFilesCount = 10;
        private FileHandler fileHandler;

        ZooKeeperFilter(String logFilePrefix) {
            String logFilePattern = logFilePrefix + ".%g.log";
            try {
                this.fileHandler = new FileHandler(logFilePattern, 0xA00000, 10, true);
                this.fileHandler.setFormatter(new VespaFormatter());
            }
            catch (IOException e) {
                System.out.println("Not able to create " + logFilePattern);
                this.fileHandler = null;
            }
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            if (record.getLoggerName() == null) {
                return true;
            }
            if (!record.getLoggerName().startsWith("org.apache.zookeeper.") && !record.getLoggerName().startsWith("org.apache.curator")) {
                return true;
            }
            this.fileHandler.publish(record);
            return false;
        }

        public void close() {
            this.fileHandler.close();
        }
    }
}

