/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.LevelController;
import com.yahoo.log.MappedLevelController;
import com.yahoo.text.Utf8;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;

class MappedLevelControllerRepo {
    private final Map<String, LevelController> levelControllerMap = new HashMap<String, LevelController>();
    private final MappedByteBuffer mapBuf;
    private final int controlFileHeaderLength;
    private final int numLevels;
    private final String logControlFilename;

    MappedLevelControllerRepo(MappedByteBuffer mapBuf, int controlFileHeaderLength, int numLevels, String logControlFilename) {
        this.mapBuf = mapBuf;
        this.controlFileHeaderLength = controlFileHeaderLength;
        this.numLevels = numLevels;
        this.logControlFilename = logControlFilename;
        this.buildMap();
    }

    private void buildMap() {
        int len = this.mapBuf.capacity();
        int startOfLine = this.controlFileHeaderLength;
        int numLine = 1;
        int i = 0;
        while (i < len) {
            if (this.mapBuf.get(i) == 10) {
                startOfLine = ++i;
                ++numLine;
                continue;
            }
            if (i < this.controlFileHeaderLength) {
                ++i;
                continue;
            }
            if (this.mapBuf.get(i) == 58) {
                int endOfName = i;
                int levels = i;
                levels += 2;
                while (levels % 4 != 0) {
                    ++levels;
                }
                int endLine = levels + 4 * this.numLevels;
                if (this.checkLine(startOfLine, endOfName, levels, endLine)) {
                    int l = endOfName - startOfLine;
                    if (l > 1 && this.mapBuf.get(startOfLine) == 46) {
                        ++startOfLine;
                        --l;
                    }
                    byte[] namebytes = new byte[l];
                    for (int j = 0; j < l; ++j) {
                        namebytes[j] = this.mapBuf.get(startOfLine + j);
                    }
                    String name = Utf8.toString((byte[])namebytes);
                    if (name.equals("default")) {
                        name = "";
                    }
                    MappedLevelController ctrl = new MappedLevelController(this.mapBuf, levels, name);
                    this.levelControllerMap.put(name, ctrl);
                    i = endLine;
                    continue;
                }
                while (i < len && this.mapBuf.get(i) != 10) {
                    ++i;
                }
                int bll = i - startOfLine;
                byte[] badline = new byte[bll];
                for (int j = 0; j < bll; ++j) {
                    badline[j] = this.mapBuf.get(startOfLine + j);
                }
                System.err.println("bad loglevel line " + numLine + " in " + this.logControlFilename + ": " + Utf8.toString((byte[])badline));
                continue;
            }
            ++i;
        }
    }

    private boolean checkLine(int sol, int endnam, int levstart, int eol) {
        if (eol >= this.mapBuf.capacity()) {
            System.err.println("line would end after end of file");
            return false;
        }
        if (this.mapBuf.get(eol) != 10) {
            System.err.println("line must end with newline, was: " + this.mapBuf.get(eol));
            return false;
        }
        if (endnam < sol + 1) {
            System.err.println("name must be at least one character after start of line");
            return false;
        }
        return MappedLevelController.checkOnOff(this.mapBuf, levstart);
    }

    LevelController getLevelController(String suffix) {
        return this.levelControllerMap.get(suffix);
    }

    void checkBack() {
        for (LevelController ctrl : this.levelControllerMap.values()) {
            ctrl.checkBack();
        }
    }
}

