/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.data.access;

import com.yahoo.data.access.ArrayTraverser;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.ObjectTraverser;
import com.yahoo.data.access.Type;
import com.yahoo.data.disclosure.DataSink;
import com.yahoo.data.disclosure.DataSource;
import java.util.Map;

public interface Inspector
extends Inspectable,
DataSource {
    public boolean valid();

    public Type type();

    public int entryCount();

    public int fieldCount();

    public boolean asBool();

    public long asLong();

    public double asDouble();

    public String asString();

    public byte[] asUtf8();

    public byte[] asData();

    public boolean asBool(boolean var1);

    public long asLong(long var1);

    public double asDouble(double var1);

    public String asString(String var1);

    public byte[] asUtf8(byte[] var1);

    public byte[] asData(byte[] var1);

    public void traverse(ArrayTraverser var1);

    public void traverse(ObjectTraverser var1);

    public Inspector entry(int var1);

    public Inspector field(String var1);

    public Iterable<Inspector> entries();

    public Iterable<Map.Entry<String, Inspector>> fields();

    @Override
    default public void emit(DataSink sink) {
        switch (this.type()) {
            case EMPTY: {
                sink.emptyValue();
                break;
            }
            case BOOL: {
                sink.booleanValue(this.asBool());
                break;
            }
            case LONG: {
                sink.longValue(this.asLong());
                break;
            }
            case DOUBLE: {
                sink.doubleValue(this.asDouble());
                break;
            }
            case STRING: {
                sink.stringValue(this.asString());
                break;
            }
            case DATA: {
                sink.dataValue(this.asData());
                break;
            }
            case ARRAY: {
                sink.startArray();
                for (Inspector entry : this.entries()) {
                    entry.emit(sink);
                }
                sink.endArray();
                break;
            }
            case OBJECT: {
                sink.startObject();
                for (Map.Entry<String, Inspector> field : this.fields()) {
                    sink.fieldName(field.getKey());
                    field.getValue().emit(sink);
                }
                sink.endObject();
            }
        }
    }
}

