/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.geo;

public class BoundingBoxParser {
    public double n = 0.0;
    public double s = 0.0;
    public double e = 0.0;
    public double w = 0.0;
    private final String parseString;
    private final int len;
    private int pos = 0;
    private int lastNumStartPos = 0;
    private char nsew = '\u0000';
    private boolean doneN = false;
    private boolean doneS = false;
    private boolean doneE = false;
    private boolean doneW = false;

    public BoundingBoxParser(String bb) {
        this.parseString = bb;
        this.len = bb.length();
        this.parse();
    }

    private char getNextChar() throws IllegalArgumentException {
        if (this.pos == this.len) {
            ++this.pos;
            return '\u0000';
        }
        if (this.pos > this.len) {
            throw new IllegalArgumentException("position after end of string");
        }
        return this.parseString.charAt(this.pos++);
    }

    private boolean isCompassDirection(char ch) {
        return ch == 'N' || ch == 'S' || ch == 'E' || ch == 'W' || ch == 'n' || ch == 's' || ch == 'e' || ch == 'w';
    }

    private void parse() {
        do {
            char ch;
            if (this.isCompassDirection(ch = this.getNextChar()) && this.nsew == '\u0000') {
                if (ch == 'n' || ch == 'N') {
                    this.nsew = (char)110;
                } else if (ch == 's' || ch == 'S') {
                    this.nsew = (char)115;
                } else if (ch == 'e' || ch == 'E') {
                    this.nsew = (char)101;
                } else if (ch == 'w' || ch == 'W') {
                    this.nsew = (char)119;
                }
                this.lastNumStartPos = 0;
            }
            if ((ch == '=' || ch == ':') && this.nsew != '\u0000') {
                this.lastNumStartPos = this.pos;
            }
            if (ch != ',' && ch != '\u0000' && ch != ' ' || this.nsew == '\u0000' || this.lastNumStartPos <= 0) continue;
            String sub = this.parseString.substring(this.lastNumStartPos, this.pos - 1);
            try {
                double v = Double.parseDouble(sub);
                if (this.nsew == 'n') {
                    if (this.doneN) {
                        throw new IllegalArgumentException("multiple limits for 'n' boundary");
                    }
                    this.n = v;
                    this.doneN = true;
                } else if (this.nsew == 's') {
                    if (this.doneS) {
                        throw new IllegalArgumentException("multiple limits for 's' boundary");
                    }
                    this.s = v;
                    this.doneS = true;
                } else if (this.nsew == 'e') {
                    if (this.doneE) {
                        throw new IllegalArgumentException("multiple limits for 'e' boundary");
                    }
                    this.e = v;
                    this.doneE = true;
                } else if (this.nsew == 'w') {
                    if (this.doneW) {
                        throw new IllegalArgumentException("multiple limits for 'w' boundary");
                    }
                    this.w = v;
                    this.doneW = true;
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse " + this.nsew + " limit '" + sub + "' as a number");
            }
            this.nsew = '\u0000';
        } while (this.pos <= this.len);
        if (this.doneN && this.doneS && this.doneE && this.doneW) {
            return;
        }
        throw new IllegalArgumentException("Missing bounding box limits, n=" + this.doneN + " s=" + this.doneS + " e=" + this.doneE + " w=" + this.doneW);
    }
}

