/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MixedTensor
implements Tensor {
    private final TensorType type;
    private final Index index;

    public List<DenseSubspace> getInternalDenseSubspaces() {
        return this.index.denseSubspaces;
    }

    private MixedTensor(TensorType type, Index index) {
        this.type = type;
        this.index = index;
    }

    @Override
    public TensorType type() {
        return this.type;
    }

    @Override
    public long size() {
        return this.index.denseSubspaces.size() * this.index.denseSubspaceSize;
    }

    @Override
    public double get(TensorAddress address) {
        DenseSubspace block = this.index.blockOf(address);
        int denseOffset = this.index.denseOffsetOf(address);
        if (block == null || denseOffset < 0 || denseOffset >= block.cells.length) {
            return 0.0;
        }
        return block.cells[denseOffset];
    }

    @Override
    public Double getAsDouble(TensorAddress address) {
        DenseSubspace block = this.index.blockOf(address);
        int denseOffset = this.index.denseOffsetOf(address);
        if (block == null || denseOffset < 0 || denseOffset >= block.cells.length) {
            return null;
        }
        return block.cells[denseOffset];
    }

    @Override
    public boolean has(TensorAddress address) {
        DenseSubspace block = this.index.blockOf(address);
        int denseOffset = this.index.denseOffsetOf(address);
        return block != null && denseOffset >= 0 && denseOffset < block.cells.length;
    }

    @Override
    public Iterator<Tensor.Cell> cellIterator() {
        return new Iterator<Tensor.Cell>(){
            final Iterator<DenseSubspace> blockIterator;
            final int[] labels;
            DenseSubspace currentBlock;
            int currOffset;
            int prevOffset;
            {
                this.blockIterator = MixedTensor.this.index.denseSubspaces.iterator();
                this.labels = new int[MixedTensor.this.index.indexedDimensions.size()];
                this.currentBlock = null;
                this.currOffset = MixedTensor.this.index.denseSubspaceSize;
                this.prevOffset = -1;
            }

            @Override
            public boolean hasNext() {
                return this.currOffset < MixedTensor.this.index.denseSubspaceSize || this.blockIterator.hasNext();
            }

            @Override
            public Tensor.Cell next() {
                if (this.currOffset == MixedTensor.this.index.denseSubspaceSize) {
                    this.currentBlock = this.blockIterator.next();
                    this.currOffset = 0;
                }
                if (this.currOffset != this.prevOffset) {
                    MixedTensor.this.index.denseOffsetToAddress(this.currOffset, this.labels);
                }
                TensorAddress fullAddr = this.currentBlock.sparseAddress.fullAddressOf(MixedTensor.this.index.type.dimensions(), this.labels);
                this.prevOffset = this.currOffset;
                double value = this.currentBlock.cells[this.currOffset++];
                return new Tensor.Cell(fullAddr, value);
            }
        };
    }

    @Override
    public Iterator<Double> valueIterator() {
        return new Iterator<Double>(){
            final Iterator<DenseSubspace> blockIterator;
            double[] currentBlock;
            int currOffset;
            {
                this.blockIterator = MixedTensor.this.index.denseSubspaces.iterator();
                this.currentBlock = null;
                this.currOffset = MixedTensor.this.index.denseSubspaceSize;
            }

            @Override
            public boolean hasNext() {
                return this.currOffset < MixedTensor.this.index.denseSubspaceSize || this.blockIterator.hasNext();
            }

            @Override
            public Double next() {
                if (this.currOffset == MixedTensor.this.index.denseSubspaceSize) {
                    this.currentBlock = this.blockIterator.next().cells;
                    this.currOffset = 0;
                }
                return this.currentBlock[this.currOffset++];
            }
        };
    }

    @Override
    public Map<TensorAddress, Double> cells() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        Iterator<Tensor.Cell> iter = this.cellIterator();
        while (iter.hasNext()) {
            Tensor.Cell cell = iter.next();
            builder.put((Object)cell.getKey(), (Object)cell.getValue());
        }
        return builder.build();
    }

    @Override
    public Tensor withType(TensorType other) {
        if (!this.type.isRenamableTo(this.type)) {
            throw new IllegalArgumentException("MixedTensor.withType: types are not compatible. Current type: '" + String.valueOf(this.type) + "', requested type: '" + String.valueOf(this.type) + "'");
        }
        return new MixedTensor(other, this.index);
    }

    @Override
    public Tensor remove(Set<TensorAddress> addresses) {
        Index.Builder indexBuilder = new Index.Builder(this.type);
        for (DenseSubspace block : this.index.denseSubspaces) {
            if (addresses.contains(block.sparseAddress)) continue;
            indexBuilder.addBlock(block);
        }
        return new MixedTensor(this.type, indexBuilder.build());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.index.denseSubspaces);
    }

    @Override
    public String toString() {
        return this.toString(true, true);
    }

    @Override
    public String toString(boolean withType, boolean shortForms) {
        return this.toString(withType, shortForms, Long.MAX_VALUE);
    }

    @Override
    public String toAbbreviatedString(boolean withType, boolean shortForms) {
        return this.toString(withType, shortForms, Math.max(2L, 10L / (this.type().dimensions().stream().filter(TensorType.Dimension::isMapped).count() + 1L)));
    }

    private String toString(boolean withType, boolean shortForms, long maxCells) {
        if (!shortForms || this.type.rank() == 0 || this.type.rank() > 1 && this.type.dimensions().stream().filter(TensorType.Dimension::isIndexed).anyMatch(d -> d.size().isEmpty()) || this.type.dimensions().stream().filter(TensorType.Dimension::isMapped).count() > 1L) {
            return Tensor.toStandardString(this, withType, shortForms, maxCells);
        }
        return (String)(withType ? String.valueOf(this.type) + ":" : "") + this.index.contentToString(this, maxCells);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Tensor)) {
            return false;
        }
        return Tensor.equals(this, (Tensor)other);
    }

    public long denseSubspaceSize() {
        return this.index.denseSubspaceSize;
    }

    public static TensorType createPartialType(TensorType.Value valueType, List<TensorType.Dimension> dimensions) {
        TensorType.Builder builder = new TensorType.Builder(valueType);
        for (TensorType.Dimension dimension : dimensions) {
            builder.set(dimension);
        }
        return builder.build();
    }

    private static class Index {
        private final TensorType type;
        private final TensorType sparseType;
        private final TensorType denseType;
        private final List<TensorType.Dimension> mappedDimensions;
        private final List<TensorType.Dimension> indexedDimensions;
        private final int[] indexedDimensionsSize;
        private ImmutableMap<TensorAddress, Integer> sparseMap;
        private List<DenseSubspace> denseSubspaces;
        private final int denseSubspaceSize;

        private static int computeDSS(List<TensorType.Dimension> dimensions) {
            long denseSubspaceSize = 1L;
            for (TensorType.Dimension dimension : dimensions) {
                denseSubspaceSize *= dimension.size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension")).longValue();
            }
            return (int)denseSubspaceSize;
        }

        private Index(TensorType type) {
            this.type = type;
            this.mappedDimensions = type.dimensions().stream().filter(d -> !d.isIndexed()).toList();
            this.indexedDimensions = type.dimensions().stream().filter(TensorType.Dimension::isIndexed).toList();
            this.indexedDimensionsSize = new int[this.indexedDimensions.size()];
            for (int i = 0; i < this.indexedDimensions.size(); ++i) {
                long dimensionSize = this.indexedDimensions.get(i).size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension."));
                this.indexedDimensionsSize[i] = (int)dimensionSize;
            }
            this.sparseType = MixedTensor.createPartialType(type.valueType(), this.mappedDimensions);
            this.denseType = MixedTensor.createPartialType(type.valueType(), this.indexedDimensions);
            this.denseSubspaceSize = Index.computeDSS(this.indexedDimensions);
            if (this.denseSubspaceSize < 1) {
                throw new IllegalStateException("invalid dense subspace size: " + this.denseSubspaceSize);
            }
        }

        private DenseSubspace blockOf(TensorAddress address) {
            TensorAddress sparsePart = address.mappedPartialAddress(this.sparseType, this.type.dimensions());
            Integer blockNum = (Integer)this.sparseMap.get((Object)sparsePart);
            if (blockNum == null || blockNum >= this.denseSubspaces.size()) {
                return null;
            }
            return this.denseSubspaces.get(blockNum);
        }

        private int denseOffsetOf(TensorAddress address) {
            long innerSize = 1L;
            long offset = 0L;
            int i = this.type.dimensions().size();
            while (--i >= 0) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) continue;
                long label = address.numericLabel(i);
                offset += label * innerSize;
                innerSize *= dimension.size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension.")).longValue();
            }
            return (int)offset;
        }

        public int denseSubspaceSize() {
            return this.denseSubspaceSize;
        }

        private void denseOffsetToAddress(long denseOffset, int[] labels) {
            if (denseOffset < 0L || denseOffset > (long)this.denseSubspaceSize) {
                throw new IllegalArgumentException("Offset out of bounds");
            }
            long restSize = denseOffset;
            long innerSize = this.denseSubspaceSize;
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = (int)(restSize / (innerSize /= (long)this.indexedDimensionsSize[i]));
                restSize %= innerSize;
            }
        }

        public String toString() {
            return "index into " + String.valueOf(this.type);
        }

        private String contentToString(MixedTensor tensor, long maxCells) {
            if (this.mappedDimensions.size() > 1) {
                throw new IllegalStateException("Should be ensured by caller");
            }
            if (this.mappedDimensions.isEmpty()) {
                StringBuilder b = new StringBuilder();
                int cellsWritten = this.denseSubspaceToString(tensor, 0, maxCells, b);
                if ((long)cellsWritten == maxCells && (long)cellsWritten < tensor.size()) {
                    b.append("...]");
                }
                return b.toString();
            }
            StringBuilder b = new StringBuilder("{");
            ArrayList cellEntries = new ArrayList(this.sparseMap.entrySet());
            cellEntries.sort(Map.Entry.comparingByKey());
            int cellsWritten = 0;
            for (int index = 0; index < cellEntries.size() && (long)cellsWritten < maxCells; ++index) {
                if (index > 0) {
                    b.append(", ");
                }
                b.append(TensorAddress.labelToString(((TensorAddress)((Map.Entry)cellEntries.get(index)).getKey()).label(0)));
                b.append(":");
                cellsWritten += this.denseSubspaceToString(tensor, (Integer)((Map.Entry)cellEntries.get(index)).getValue(), maxCells - (long)cellsWritten, b);
            }
            if ((long)cellsWritten >= maxCells && (long)cellsWritten < tensor.size()) {
                b.append(", ...");
            }
            b.append("}");
            return b.toString();
        }

        private int denseSubspaceToString(MixedTensor tensor, int subspaceIndex, long maxCells, StringBuilder b) {
            int index;
            if (maxCells <= 0L) {
                return 0;
            }
            if (this.denseSubspaceSize == 1) {
                b.append(this.getDouble(subspaceIndex, 0, tensor));
                return 1;
            }
            IndexedTensor.Indexes indexes = IndexedTensor.Indexes.of(this.denseType);
            for (index = 0; index < this.denseSubspaceSize && (long)index < maxCells; ++index) {
                indexes.next();
                if (index > 0) {
                    b.append(", ");
                }
                b.append("[".repeat(Math.max(0, indexes.nextDimensionsAtStart())));
                switch (this.type.valueType()) {
                    case DOUBLE: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case FLOAT: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case BFLOAT16: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case INT8: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value type " + String.valueOf((Object)this.type.valueType()));
                    }
                }
                b.append("]".repeat(Math.max(0, indexes.nextDimensionsAtEnd())));
            }
            return index;
        }

        private double getDouble(int subspaceIndex, int denseOffset, MixedTensor tensor) {
            return tensor.index.denseSubspaces.get((int)subspaceIndex).cells[denseOffset];
        }

        private static class Builder {
            private final Index index;
            private final ImmutableMap.Builder<TensorAddress, Integer> builder = new ImmutableMap.Builder();
            private final ImmutableList.Builder<DenseSubspace> listBuilder = new ImmutableList.Builder();
            private int count = 0;

            Builder(TensorType type) {
                this.index = new Index(type);
            }

            void addBlock(DenseSubspace block) {
                if (block.cells.length != this.index.denseSubspaceSize) {
                    throw new IllegalStateException("dense subspace size mismatch, expected " + this.index.denseSubspaceSize + " cells, but got: " + block.cells.length);
                }
                this.builder.put((Object)block.sparseAddress, (Object)this.count++);
                this.listBuilder.add((Object)block);
            }

            Index build() {
                this.index.sparseMap = this.builder.build();
                this.index.denseSubspaces = this.listBuilder.build();
                return this.index;
            }

            Index index() {
                return this.index;
            }
        }
    }

    public static final class DenseSubspace {
        public final TensorAddress sparseAddress;
        public final double[] cells;

        DenseSubspace(TensorAddress sparseAddress, double[] cells) {
            this.sparseAddress = sparseAddress;
            this.cells = cells;
        }

        public int hashCode() {
            return Objects.hash(this.sparseAddress, this.cells[0]);
        }

        public boolean equals(Object other) {
            if (other instanceof DenseSubspace) {
                DenseSubspace o = (DenseSubspace)other;
                return this.sparseAddress.equals(o.sparseAddress) && Arrays.equals(this.cells, o.cells);
            }
            return false;
        }
    }

    private record DenseSubspaceBuilder(TensorType type, double[] values) implements IndexedTensor.DirectIndexBuilder
    {
        @Override
        public void cellByDirectIndex(long index, double value) {
            this.values[(int)index] = value;
        }

        @Override
        public void cellByDirectIndex(long index, float value) {
            this.values[(int)index] = value;
        }
    }

    private static class UnboundBuilder
    extends Builder {
        private final Map<TensorAddress, Double> cells;
        private final long[] dimensionBounds;

        private UnboundBuilder(TensorType type, int expectedSize) {
            super(type);
            this.cells = new LinkedHashMap<TensorAddress, Double>(expectedSize, 0.5f);
            this.dimensionBounds = new long[type.dimensions().size()];
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, double value) {
            this.cells.put(address, value);
            this.trackBounds(address);
            return this;
        }

        @Override
        public MixedTensor build() {
            TensorType boundType = this.createBoundType();
            BoundBuilder builder = new BoundBuilder(boundType, this.cells.size());
            for (Map.Entry<TensorAddress, Double> cell : this.cells.entrySet()) {
                builder.cell(cell.getKey(), (double)cell.getValue());
            }
            return builder.build();
        }

        private void trackBounds(TensorAddress address) {
            for (int i = 0; i < this.type.dimensions().size(); ++i) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) continue;
                this.dimensionBounds[i] = Math.max(address.numericLabel(i), this.dimensionBounds[i]);
            }
        }

        private TensorType createBoundType() {
            TensorType.Builder typeBuilder = new TensorType.Builder(this.type().valueType());
            for (int i = 0; i < this.type.dimensions().size(); ++i) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) {
                    typeBuilder.mapped(dimension.name());
                    continue;
                }
                long size = dimension.size().orElse(this.dimensionBounds[i] + 1L);
                typeBuilder.indexed(dimension.name(), size);
            }
            return typeBuilder.build();
        }

        public static UnboundBuilder of(TensorType type) {
            return new UnboundBuilder(type, 1000);
        }
    }

    public static class BoundBuilder
    extends Builder {
        private final Map<TensorAddress, double[]> denseSubspaceMap;
        private final Index.Builder indexBuilder;
        private final Index index;
        private final TensorType denseSubtype;

        private BoundBuilder(TensorType type, int expectedSize) {
            super(type);
            this.denseSubspaceMap = new LinkedHashMap<TensorAddress, double[]>(expectedSize, 0.5f);
            this.indexBuilder = new Index.Builder(type);
            this.index = this.indexBuilder.index();
            this.denseSubtype = new TensorType(type.valueType(), type.dimensions().stream().filter(TensorType.Dimension::isIndexed).toList());
        }

        public long denseSubspaceSize() {
            return this.index.denseSubspaceSize();
        }

        private double[] denseSubspace(TensorAddress sparseAddress) {
            return this.denseSubspaceMap.computeIfAbsent(sparseAddress, key -> new double[(int)this.denseSubspaceSize()]);
        }

        public IndexedTensor.DirectIndexBuilder denseSubspaceBuilder(TensorAddress sparseAddress) {
            double[] values = new double[(int)this.denseSubspaceSize()];
            this.denseSubspaceMap.put(sparseAddress, values);
            return new DenseSubspaceBuilder(this.denseSubtype, values);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, double value) {
            TensorAddress sparsePart = address.mappedPartialAddress(this.index.sparseType, this.index.type.dimensions());
            int denseOffset = this.index.denseOffsetOf(address);
            double[] denseSubspace = this.denseSubspace(sparsePart);
            denseSubspace[denseOffset] = value;
            return this;
        }

        public Tensor.Builder block(TensorAddress sparsePart, double[] values) {
            int denseSubspaceSize = (int)this.denseSubspaceSize();
            if (values.length < denseSubspaceSize) {
                throw new IllegalArgumentException("Block should have " + denseSubspaceSize + " values, but has only " + values.length);
            }
            double[] denseSubspace = this.denseSubspace(sparsePart);
            System.arraycopy(values, 0, denseSubspace, 0, denseSubspaceSize);
            return this;
        }

        @Override
        public MixedTensor build() {
            Set<Map.Entry<TensorAddress, double[]>> entrySet = this.denseSubspaceMap.entrySet();
            for (Map.Entry<TensorAddress, double[]> entry : entrySet) {
                TensorAddress sparsePart = entry.getKey();
                double[] denseSubspace = entry.getValue();
                DenseSubspace block = new DenseSubspace(sparsePart, denseSubspace);
                this.indexBuilder.addBlock(block);
            }
            return new MixedTensor(this.type, this.indexBuilder.build());
        }

        public static BoundBuilder of(TensorType type) {
            return new BoundBuilder(type, 1000);
        }
    }

    public static abstract class Builder
    implements Tensor.Builder {
        static final int INITIAL_HASH_CAPACITY = 1000;
        final TensorType type;

        public static Builder of(TensorType type) {
            if (type.hasIndexedUnboundDimensions()) {
                return new UnboundBuilder(type, 1000);
            }
            return new BoundBuilder(type, 1000);
        }

        private Builder(TensorType type) {
            this.type = type;
        }

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public Tensor.Builder cell(float value, long ... labels) {
            return this.cell((double)value, labels);
        }

        @Override
        public Tensor.Builder cell(double value, long ... labels) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type(), this);
        }

        @Override
        public abstract MixedTensor build();
    }
}

