/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayValue;
import com.yahoo.slime.BoolValue;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.DataValue;
import com.yahoo.slime.DoubleValue;
import com.yahoo.slime.LongValue;
import com.yahoo.slime.NixValue;
import com.yahoo.slime.ObjectValue;
import com.yahoo.slime.StringValue;
import com.yahoo.slime.SymbolTable;
import com.yahoo.slime.Utf8Value;
import com.yahoo.slime.Value;

public final class Slime {
    private final SymbolTable names = new SymbolTable();
    private Value root = NixValue.instance();

    SymbolTable symbolTable() {
        return this.names;
    }

    public int symbols() {
        return this.names.symbols();
    }

    public String inspect(int symbol) {
        return this.names.inspect(symbol);
    }

    public int insert(String name) {
        return this.names.insert(name);
    }

    public int lookup(String name) {
        return this.names.lookup(name);
    }

    public Cursor get() {
        return this.root;
    }

    public Cursor setNix() {
        this.root = NixValue.instance();
        return this.root;
    }

    public Cursor setBool(boolean bit) {
        this.root = BoolValue.instance(bit);
        return this.root;
    }

    public Cursor setLong(long l) {
        this.root = new LongValue(l);
        return this.root;
    }

    public Cursor setDouble(double d) {
        this.root = new DoubleValue(d);
        return this.root;
    }

    public Cursor setString(String str) {
        this.root = StringValue.create(str);
        return this.root;
    }

    public Cursor setString(byte[] utf8) {
        this.root = Utf8Value.create(utf8);
        return this.root;
    }

    public Cursor setData(byte[] data) {
        this.root = DataValue.create(data);
        return this.root;
    }

    public Cursor setArray() {
        this.root = new ArrayValue(this.names);
        return this.root;
    }

    public Cursor setObject() {
        this.root = new ObjectValue(this.names);
        return this.root;
    }

    public Cursor wrap(int sym) {
        this.root = new ObjectValue(this.names, sym, this.root);
        return this.root;
    }

    public Cursor wrap(String name) {
        return this.wrap(this.names.insert(name));
    }

    public boolean equalTo(Slime that) {
        return this.get().equalTo(that.get());
    }

    public String toString() {
        return this.get().toString();
    }
}

