/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import java.util.LinkedList;
import java.util.List;

public class EventBarrier {
    private final List<Entry> queue = new LinkedList<Entry>();
    private int barrierToken = 0;
    private int eventCount = 0;

    int getNumEvents() {
        int cnt = this.eventCount;
        for (Entry entry : this.queue) {
            cnt += entry.eventCount;
        }
        return cnt;
    }

    int getNumBarriers() {
        return this.queue.size();
    }

    public int startEvent() {
        ++this.eventCount;
        return this.barrierToken;
    }

    public void completeEvent(int token) {
        if (token == this.barrierToken) {
            --this.eventCount;
            return;
        }
        --this.queue.get((int)(this.queue.size() - (this.barrierToken - token))).eventCount;
        while (!this.queue.isEmpty() && this.queue.get((int)0).eventCount == 0) {
            this.queue.remove((int)0).handler.completeBarrier();
        }
    }

    public boolean startBarrier(BarrierWaiter handler) {
        if (this.eventCount == 0 && this.queue.isEmpty()) {
            return false;
        }
        this.queue.add(new Entry(this.eventCount, handler));
        ++this.barrierToken;
        this.eventCount = 0;
        return true;
    }

    private static class Entry {
        int eventCount;
        final BarrierWaiter handler;

        Entry(int eventCount, BarrierWaiter handler) {
            this.eventCount = eventCount;
            this.handler = handler;
        }
    }

    public static interface BarrierWaiter {
        public void completeBarrier();
    }
}

