/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StringUtilities {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final ReplacementCharacters replacementCharacters = new ReplacementCharacters();

    private static byte toHex(int val) {
        return (byte)(val < 10 ? 48 + val : 97 + (val - 10));
    }

    public static String toHex(byte[] bytes) {
        byte[] encoded = new byte[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            encoded[i * 2] = StringUtilities.toHex(bytes[i] >> 4 & 0xF);
            encoded[i * 2 + 1] = StringUtilities.toHex(bytes[i] & 0xF);
        }
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public static String escape(String source) {
        return StringUtilities.escape(source, '\u0000');
    }

    public static String escape(String source, char delimiter) {
        byte[] bytes = source.getBytes(UTF8);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        for (int n : bytes) {
            int val = n;
            if (val < 0) {
                val += 256;
            }
            if (n == delimiter) {
                result.write(92);
                result.write(120);
                result.write(StringUtilities.toHex(val >> 4 & 0xF));
                result.write(StringUtilities.toHex(val & 0xF));
                continue;
            }
            if (StringUtilities.replacementCharacters.needEscape[val] == 0) {
                result.write(n);
                continue;
            }
            if (StringUtilities.replacementCharacters.needEscape[val] == 3) {
                result.write(92);
                result.write(120);
            }
            result.write(StringUtilities.replacementCharacters.replacement1[val]);
            result.write(StringUtilities.replacementCharacters.replacement2[val]);
        }
        return result.toString(UTF8);
    }

    public static String unescape(String source) {
        byte[] bytes = source.getBytes(UTF8);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 92) {
                result.write(bytes[i]);
                continue;
            }
            if (i + 1 == bytes.length) {
                throw new IllegalArgumentException("Found backslash at end of input");
            }
            if (bytes[i + 1] != 120) {
                switch (bytes[i + 1]) {
                    case 92: {
                        result.write(92);
                        break;
                    }
                    case 34: {
                        result.write(34);
                        break;
                    }
                    case 116: {
                        result.write(9);
                        break;
                    }
                    case 110: {
                        result.write(10);
                        break;
                    }
                    case 114: {
                        result.write(13);
                        break;
                    }
                    case 102: {
                        result.write(12);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal escape sequence \\" + (char)bytes[i + 1] + " found");
                    }
                }
                ++i;
                continue;
            }
            if (i + 3 >= bytes.length) {
                throw new IllegalArgumentException("Found \\x at end of input");
            }
            String hexdigits = "" + (char)bytes[i + 2] + (char)bytes[i + 3];
            result.write((byte)Integer.parseInt(hexdigits, 16));
            i += 3;
        }
        return result.toString(UTF8);
    }

    public static String implode(String[] array, String sepString) {
        if (array == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        if (sepString == null) {
            sepString = "";
        }
        for (int i = 0; i < array.length; ++i) {
            ret.append(array[i]);
            if (i == array.length - 1) continue;
            ret.append(sepString);
        }
        return ret.toString();
    }

    public static String implodeMultiline(List<String> lines) {
        if (lines == null) {
            return null;
        }
        return StringUtilities.implode(lines.toArray(new String[0]), "\n");
    }

    public static String truncateSequencesIfNecessary(String text, int maxConsecutiveLength) {
        char prev = '\u0000';
        int sequenceCount = 1;
        int m = text.length();
        for (int i = 0; i < m; ++i) {
            char curr = text.charAt(i);
            if (prev == curr) {
                if (++sequenceCount <= maxConsecutiveLength) continue;
                return StringUtilities.truncateSequences(text, maxConsecutiveLength, i);
            }
            sequenceCount = 1;
            prev = curr;
        }
        return text;
    }

    private static String truncateSequences(String text, int maxConsecutiveLength, int firstTruncationPos) {
        char[] truncated = text.toCharArray();
        char prev = truncated[firstTruncationPos];
        int sequenceCount = maxConsecutiveLength + 1;
        int wp = firstTruncationPos;
        for (int rp = wp + 1; rp < truncated.length; ++rp) {
            char curr = truncated[rp];
            if (prev == curr) {
                if (++sequenceCount > maxConsecutiveLength) continue;
                truncated[wp++] = curr;
                continue;
            }
            truncated[wp++] = curr;
            sequenceCount = 1;
            prev = curr;
        }
        return String.copyValueOf(truncated, 0, wp);
    }

    public static String stripSuffix(String string, String suffix) {
        int index = string.lastIndexOf(suffix);
        return index == -1 ? string : string.substring(0, index);
    }

    public static String quote(Object object) {
        return "'" + object.toString() + "'";
    }

    public static Set<String> split(String s) {
        if (s == null || s.isEmpty()) {
            return Set.of();
        }
        HashSet<String> b = new HashSet<String>();
        for (String item : s.split("[\\s,]")) {
            if (item.isEmpty()) continue;
            b.add(item);
        }
        return Set.copyOf(b);
    }

    private static class ReplacementCharacters {
        public byte[] needEscape = new byte[256];
        public byte[] replacement1 = new byte[256];
        public byte[] replacement2 = new byte[256];

        public ReplacementCharacters() {
            for (int i = 0; i < 256; ++i) {
                if (i >= 32 && i <= 126) {
                    this.needEscape[i] = 0;
                    continue;
                }
                this.needEscape[i] = 3;
                this.replacement1[i] = StringUtilities.toHex(i >> 4 & 0xF);
                this.replacement2[i] = StringUtilities.toHex(i & 0xF);
            }
            this.makeSimpleEscape('\"', '\"');
            this.makeSimpleEscape('\\', '\\');
            this.makeSimpleEscape('\t', 't');
            this.makeSimpleEscape('\n', 'n');
            this.makeSimpleEscape('\r', 'r');
            this.makeSimpleEscape('\f', 'f');
        }

        private void makeSimpleEscape(char source, char dest) {
            this.needEscape[source] = 1;
            this.replacement1[source] = 92;
            this.replacement2[source] = (byte)dest;
        }
    }
}

