/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.impl.GracePeriodCircuitBreaker;
import ai.vespa.feed.client.impl.HttpFeedClient;
import ai.vespa.feed.client.impl.SslContextBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class FeedClientBuilderImpl
implements FeedClientBuilder {
    static final FeedClient.RetryStrategy defaultRetryStrategy = new FeedClient.RetryStrategy(){};
    List<URI> endpoints;
    final Map<String, Supplier<String>> requestHeaders = new HashMap<String, Supplier<String>>();
    final Map<String, Supplier<String>> proxyRequestHeaders = new HashMap<String, Supplier<String>>();
    SSLContext sslContext;
    HostnameVerifier hostnameVerifier;
    HostnameVerifier proxyHostnameVerifier;
    int connectionsPerEndpoint = 8;
    int maxStreamsPerConnection = 128;
    FeedClient.RetryStrategy retryStrategy = defaultRetryStrategy;
    FeedClient.CircuitBreaker circuitBreaker = new GracePeriodCircuitBreaker(Duration.ofSeconds(10L));
    Path certificateFile;
    Path privateKeyFile;
    Path caCertificatesFile;
    Path proxyCaCertificatesFile;
    Collection<X509Certificate> certificate;
    PrivateKey privateKey;
    Collection<X509Certificate> caCertificates;
    Collection<X509Certificate> proxyCaCertificates;
    boolean benchmark = true;
    boolean dryrun = false;
    boolean speedTest = false;
    FeedClientBuilder.Compression compression = FeedClientBuilder.Compression.auto;
    URI proxy;
    Duration connectionTtl = Duration.ZERO;
    LongSupplier nanoClock = System::nanoTime;
    int initialInflightFactor = 1;

    public FeedClientBuilderImpl() {
    }

    FeedClientBuilderImpl(List<URI> endpoints) {
        this();
        this.setEndpointUris(endpoints);
    }

    public FeedClientBuilder setEndpointUris(List<URI> endpoints) {
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException("At least one endpoint must be provided");
        }
        for (URI endpoint : endpoints) {
            Objects.requireNonNull(endpoint.getHost());
        }
        this.endpoints = new ArrayList<URI>(endpoints);
        return this;
    }

    public FeedClientBuilderImpl setConnectionsPerEndpoint(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max connections must be at least 1, but was " + max);
        }
        this.connectionsPerEndpoint = max;
        return this;
    }

    public FeedClientBuilderImpl setMaxStreamPerConnection(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max streams per connection must be at least 1, but was " + max);
        }
        this.maxStreamsPerConnection = max;
        return this;
    }

    public FeedClientBuilder setConnectionTimeToLive(Duration ttl) {
        if (ttl.isNegative()) {
            throw new IllegalArgumentException("Connection TTL cannot be negative, but was " + String.valueOf(ttl));
        }
        this.connectionTtl = ttl;
        return this;
    }

    public FeedClientBuilderImpl setSslContext(SSLContext context) {
        this.sslContext = Objects.requireNonNull(context);
        return this;
    }

    public FeedClientBuilderImpl setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = Objects.requireNonNull(verifier);
        return this;
    }

    public FeedClientBuilder setProxyHostnameVerifier(HostnameVerifier verifier) {
        this.proxyHostnameVerifier = Objects.requireNonNull(verifier);
        return this;
    }

    public FeedClientBuilderImpl noBenchmarking() {
        this.benchmark = false;
        return this;
    }

    public FeedClientBuilderImpl addRequestHeader(String name, String value) {
        return this.addRequestHeader(name, () -> Objects.requireNonNull(value));
    }

    public FeedClientBuilderImpl addRequestHeader(String name, Supplier<String> valueSupplier) {
        this.requestHeaders.put(Objects.requireNonNull(name), Objects.requireNonNull(valueSupplier));
        return this;
    }

    public FeedClientBuilder addProxyRequestHeader(String name, String value) {
        this.proxyRequestHeaders.put(Objects.requireNonNull(name), () -> Objects.requireNonNull(value));
        return this;
    }

    public FeedClientBuilder addProxyRequestHeader(String name, Supplier<String> valueSupplier) {
        this.proxyRequestHeaders.put(Objects.requireNonNull(name), Objects.requireNonNull(valueSupplier));
        return this;
    }

    public FeedClientBuilderImpl setRetryStrategy(FeedClient.RetryStrategy strategy) {
        this.retryStrategy = Objects.requireNonNull(strategy);
        return this;
    }

    public FeedClientBuilderImpl setCircuitBreaker(FeedClient.CircuitBreaker breaker) {
        this.circuitBreaker = Objects.requireNonNull(breaker);
        return this;
    }

    public FeedClientBuilderImpl setCertificate(Path certificatePemFile, Path privateKeyPemFile) {
        this.certificateFile = certificatePemFile;
        this.privateKeyFile = privateKeyPemFile;
        return this;
    }

    public FeedClientBuilderImpl setCertificate(Collection<X509Certificate> certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        return this;
    }

    public FeedClientBuilderImpl setCertificate(X509Certificate certificate, PrivateKey privateKey) {
        return this.setCertificate(List.of(certificate), privateKey);
    }

    public FeedClientBuilderImpl setDryrun(boolean enabled) {
        this.dryrun = enabled;
        return this;
    }

    public FeedClientBuilderImpl setSpeedTest(boolean enabled) {
        this.speedTest = enabled;
        return this;
    }

    public FeedClientBuilderImpl setCaCertificatesFile(Path caCertificatesFile) {
        this.caCertificatesFile = caCertificatesFile;
        return this;
    }

    public FeedClientBuilderImpl setProxyCaCertificatesFile(Path caCertificatesFile) {
        this.proxyCaCertificatesFile = caCertificatesFile;
        return this;
    }

    public FeedClientBuilderImpl setCaCertificates(Collection<X509Certificate> caCertificates) {
        this.caCertificates = caCertificates;
        return this;
    }

    public FeedClientBuilder setProxyCaCertificates(Collection<X509Certificate> caCertificates) {
        this.proxyCaCertificates = caCertificates;
        return null;
    }

    public FeedClientBuilderImpl setProxy(URI uri) {
        this.proxy = uri;
        return this;
    }

    public FeedClientBuilderImpl setCompression(FeedClientBuilder.Compression compression) {
        this.compression = Objects.requireNonNull(compression);
        return this;
    }

    FeedClientBuilderImpl setNanoClock(LongSupplier nanoClock) {
        this.nanoClock = Objects.requireNonNull(nanoClock);
        return this;
    }

    public FeedClientBuilderImpl setInitialInflightFactor(int factor) {
        if (factor < 1) {
            throw new IllegalArgumentException("Initial inflight factor must be at least 1, but was " + factor);
        }
        this.initialInflightFactor = factor;
        return this;
    }

    public FeedClient build() {
        try {
            this.validateConfiguration();
            return new HttpFeedClient(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    SSLContext constructSslContext() throws IOException {
        if (this.sslContext != null) {
            return this.sslContext;
        }
        SslContextBuilder sslContextBuilder = new SslContextBuilder();
        if (this.certificateFile != null && this.privateKeyFile != null) {
            sslContextBuilder.withCertificateAndKey(this.certificateFile, this.privateKeyFile);
        } else if (this.certificate != null && this.privateKey != null) {
            sslContextBuilder.withCertificateAndKey(this.certificate, this.privateKey);
        }
        if (this.caCertificatesFile != null) {
            sslContextBuilder.withCaCertificates(this.caCertificatesFile);
        } else if (this.caCertificates != null) {
            sslContextBuilder.withCaCertificates(this.caCertificates);
        }
        return sslContextBuilder.build();
    }

    SSLContext constructProxySslContext() throws IOException {
        SslContextBuilder b = new SslContextBuilder();
        if (this.proxyCaCertificatesFile != null) {
            b.withCaCertificates(this.proxyCaCertificatesFile);
        } else if (this.proxyCaCertificates != null) {
            b.withCaCertificates(this.proxyCaCertificates);
        }
        return b.build();
    }

    private void validateConfiguration() {
        if (this.endpoints == null) {
            throw new IllegalArgumentException("At least one endpoint must be provided");
        }
        if (this.sslContext != null && (this.certificateFile != null || this.caCertificatesFile != null || this.privateKeyFile != null || this.certificate != null || this.caCertificates != null || this.privateKey != null)) {
            throw new IllegalArgumentException("Cannot set both SSLContext and certificate / CA certificates");
        }
        if (this.certificate != null && this.certificateFile != null) {
            throw new IllegalArgumentException("Cannot set both certificate directly and as file");
        }
        if (this.privateKey != null && this.privateKeyFile != null) {
            throw new IllegalArgumentException("Cannot set both private key directly and as file");
        }
        if (this.caCertificates != null && this.caCertificatesFile != null) {
            throw new IllegalArgumentException("Cannot set both CA certificates directly and as file");
        }
        if (this.certificate != null && this.certificate.isEmpty()) {
            throw new IllegalArgumentException("Certificate cannot be empty");
        }
        if (this.caCertificates != null && this.caCertificates.isEmpty()) {
            throw new IllegalArgumentException("CA certificates cannot be empty");
        }
    }
}

