/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import java.util.Comparator;
import java.util.Objects;

public class Version
implements Comparable<Version> {
    private static final Comparator<Version> comparator = Comparator.comparingInt(Version::major).thenComparing(Version::isSnapshot).thenComparing(Version::minor).thenComparing(Version::micro);
    private final int major;
    private final int minor;
    private final int micro;
    private final boolean snapshot;

    private Version(int major, int minor, int micro, boolean snapshot) {
        if (major < 0 || minor < 0 || micro < 0) {
            throw new IllegalArgumentException("version numbers must all be non-negative");
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.snapshot = snapshot;
    }

    public static Version of(int major, int minor, int micro) {
        return new Version(major, minor, micro, false);
    }

    public static Version ofSnapshot(int major) {
        return new Version(major, 0, 0, true);
    }

    public static Version from(String version) {
        if (version.endsWith("-SNAPSHOT")) {
            String[] parts = version.split("-");
            if (parts.length != 2) {
                throw new IllegalArgumentException("snapshot version must only specify major, e.g., \"1-SNAPSHOT\"");
            }
            return Version.ofSnapshot(Integer.parseInt(parts[0]));
        }
        String[] parts = version.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("release versions must specify major, minor and micro, separated by '.', e.g., \"1.2.0\"");
        }
        return Version.of(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int micro() {
        return this.micro;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro && this.snapshot == version.snapshot;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.micro, this.snapshot);
    }

    @Override
    public int compareTo(Version other) {
        return comparator.compare(this, other);
    }

    public String toString() {
        return this.isSnapshot() ? this.major + "-SNAPSHOT" : this.major + "." + this.minor + "." + this.micro;
    }
}

