/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd;

import java.net.http.HttpRequest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public interface EndpointAuthenticator {
    default public SSLContext sslContext() {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    default public HttpRequest.Builder authenticated(HttpRequest.Builder request) {
        Map<String, String> authorizationHeaders = this.authorizationHeaders();
        if (authorizationHeaders.isEmpty()) {
            return request;
        }
        Map<String, List<String>> headers = request.build().headers().map();
        authorizationHeaders.forEach((name, value) -> {
            if (!headers.containsKey(name)) {
                request.setHeader((String)name, (String)value);
            }
        });
        return request;
    }

    default public Map<String, String> authorizationHeaders() {
        return Map.of();
    }
}

