/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features;

import com.yahoo.searchlib.ranking.features.Features;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ElementCompleteness {
    private static final double fieldCompletenessImportance = 0.05;

    public static Features compute(Map<String, Integer> queryTerms, Item[] field) {
        double completeness = 0.0;
        double fieldCompleteness = 0.0;
        double queryCompleteness = 0.0;
        double elementWeight = 0.0;
        double queryTermWeightSum = ElementCompleteness.sum(queryTerms.values());
        for (Item item : field) {
            String[] itemTokens = item.value().split(" ");
            int matchCount = 0;
            int matchWeightSum = 0;
            for (String token : itemTokens) {
                Integer weight = queryTerms.get(token);
                if (weight == null) continue;
                ++matchCount;
                matchWeightSum += weight.intValue();
            }
            double itemFieldCompleteness = (double)matchCount / (double)itemTokens.length;
            double itemQueryCompleteness = (double)matchWeightSum / queryTermWeightSum;
            double itemCompleteness = 0.05 * itemFieldCompleteness + 0.95 * itemQueryCompleteness;
            if (!(itemCompleteness > completeness)) continue;
            completeness = itemCompleteness;
            fieldCompleteness = itemFieldCompleteness;
            queryCompleteness = itemQueryCompleteness;
            elementWeight = item.weight();
        }
        HashMap<String, Value> features = new HashMap<String, Value>();
        features.put("completeness", new DoubleValue(completeness));
        features.put("fieldCompleteness", new DoubleValue(fieldCompleteness));
        features.put("queryCompleteness", new DoubleValue(queryCompleteness));
        features.put("elementWeight", new DoubleValue(elementWeight));
        return new Features(features);
    }

    private static int sum(Collection<Integer> integers) {
        int sum = 0;
        for (int integer : integers) {
            sum += integer;
        }
        return sum;
    }

    public static class Item {
        private final String value;
        private final double weight;

        public Item(String value, double weight) {
            this.value = value;
            this.weight = weight;
        }

        public String value() {
            return this.value;
        }

        public double weight() {
            return this.weight;
        }
    }
}

