/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.Hit;
import com.yahoo.searchlib.aggregation.RawData;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class VdsHit
extends Hit {
    public static final int classId = VdsHit.registerClass((int)16480, VdsHit.class, VdsHit::new);
    private String docId = "";
    private RawData summary = new RawData();

    public VdsHit() {
    }

    public VdsHit(String docId, byte[] summary, double rank) {
        super(rank);
        this.docId = docId;
        this.summary = new RawData(summary);
    }

    public RawData getSummary() {
        return this.summary;
    }

    public String getDocId() {
        return this.docId;
    }

    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        byte[] utf8 = Utf8.toBytes((String)this.docId);
        buf.putInt(null, utf8.length);
        buf.put(null, utf8);
        this.summary.serialize(buf);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.docId = this.getUtf8(buf);
        this.summary.deserialize(buf);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.docId.hashCode() + this.summary.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        VdsHit rhs = (VdsHit)((Object)obj);
        return super.equals(obj) && this.docId.equals(rhs.docId) && this.summary.equals(rhs.summary);
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("docId", (Object)this.docId);
        visitor.visit("summary", (Object)this.summary);
    }
}

