/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.Group;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.FilterExpressionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.Objects;

public class GroupingLevel
extends Identifiable {
    public static final int classId = GroupingLevel.registerClass((int)16477, GroupingLevel.class, GroupingLevel::new);
    public static final int classIdV2 = GroupingLevel.registerClass((int)16553, GroupingLevel.class, () -> new GroupingLevel().setV2());
    private long maxGroups = -1L;
    private long precision = -1L;
    private ExpressionNode classify = null;
    private FilterExpressionNode filter = null;
    private boolean v2 = false;
    private Group collect = new Group();

    GroupingLevel setV2() {
        this.v2 = true;
        return this;
    }

    boolean hasFilter() {
        return this.filter != null;
    }

    public long getPrecision() {
        return this.precision;
    }

    public long getMaxGroups() {
        return this.maxGroups;
    }

    public GroupingLevel setMaxGroups(long max) {
        this.maxGroups = max;
        if (this.precision < this.maxGroups) {
            this.precision = this.maxGroups;
        }
        return this;
    }

    public GroupingLevel setPrecision(long precision) {
        this.precision = precision;
        return this;
    }

    public ExpressionNode getExpression() {
        return this.classify;
    }

    public GroupingLevel setExpression(ExpressionNode exp) {
        this.classify = exp;
        return this;
    }

    public FilterExpressionNode getFilter() {
        return this.filter;
    }

    public GroupingLevel setFilter(FilterExpressionNode filter) {
        this.filter = filter;
        return this.setV2();
    }

    public GroupingLevel setGroupPrototype(Group group) {
        this.collect = group;
        return this;
    }

    public Group getGroupPrototype() {
        return this.collect;
    }

    public boolean needResultCollection() {
        return !this.collect.isRankedByRelevance();
    }

    protected int onGetClassId() {
        return this.v2 ? classIdV2 : classId;
    }

    protected void onSerialize(Serializer buf) {
        buf.putLong(null, this.maxGroups);
        buf.putLong(null, this.precision);
        GroupingLevel.serializeOptional((Serializer)buf, (Identifiable)this.classify);
        if (this.v2) {
            GroupingLevel.serializeOptional((Serializer)buf, (Identifiable)this.filter);
        } else if (this.filter != null) {
            throw new IllegalStateException("Filter set on v1 GroupingLevel");
        }
        this.collect.serializeWithId(buf);
    }

    protected void onDeserialize(Deserializer buf) {
        this.maxGroups = buf.getLong(null);
        this.precision = buf.getLong(null);
        this.classify = (ExpressionNode)GroupingLevel.deserializeOptional((Deserializer)buf);
        if (this.v2) {
            this.filter = (FilterExpressionNode)GroupingLevel.deserializeOptional((Deserializer)buf);
        }
        this.collect.deserializeWithId(buf);
    }

    public int hashCode() {
        return super.hashCode() + (int)this.maxGroups + (int)this.precision + this.collect.hashCode() + Objects.hashCode((Object)this.filter);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GroupingLevel rhs = (GroupingLevel)((Object)obj);
        if (this.maxGroups != rhs.maxGroups) {
            return false;
        }
        if (this.precision != rhs.precision) {
            return false;
        }
        if (!GroupingLevel.equals((Object)this.classify, (Object)rhs.classify)) {
            return false;
        }
        if (!GroupingLevel.equals((Object)((Object)this.filter), (Object)((Object)rhs.filter))) {
            return false;
        }
        return this.collect.equals((Object)rhs.collect);
    }

    public GroupingLevel clone() {
        GroupingLevel obj = (GroupingLevel)super.clone();
        if (this.classify != null) {
            obj.classify = this.classify.clone();
        }
        if (this.filter != null) {
            obj.filter = this.filter.clone();
        }
        obj.collect = this.collect.clone();
        return obj;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("maxGroups", (Object)this.maxGroups);
        visitor.visit("precision", (Object)this.precision);
        visitor.visit("classify", (Object)this.classify);
        visitor.visit("filter", (Object)this.filter);
        visitor.visit("collect", (Object)this.collect);
    }
}

