/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.gbdt;

import com.yahoo.searchlib.gbdt.CategoryFeatureNode;
import com.yahoo.searchlib.gbdt.NumericFeatureNode;
import com.yahoo.searchlib.gbdt.TreeNode;
import com.yahoo.searchlib.gbdt.XmlHelper;
import com.yahoo.searchlib.rankingexpression.evaluation.StringValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class FeatureNode
extends TreeNode {
    private final String feature;
    private final TreeNode left;
    private final TreeNode right;

    public FeatureNode(String feature, Optional<Integer> samples, TreeNode left, TreeNode right) {
        super(samples);
        this.feature = feature;
        this.left = left;
        this.right = right;
    }

    public String feature() {
        return this.feature;
    }

    public TreeNode left() {
        return this.left;
    }

    public TreeNode right() {
        return this.right;
    }

    @Override
    public String toRankingExpression() {
        StringBuilder expression = new StringBuilder();
        expression.append("if (").append(this.feature).append(this.rankingExpressionCondition());
        expression.append(", ").append(this.left.toRankingExpression());
        expression.append(", ").append(this.right.toRankingExpression());
        Optional<Float> trueProbability = this.trueProbability();
        if (trueProbability.isPresent()) {
            expression.append(", ").append(trueProbability.get());
        }
        expression.append(")");
        return expression.toString();
    }

    private Optional<Float> trueProbability() {
        if (this.left.samples().isPresent() && this.right.samples().isPresent()) {
            return Optional.of(Float.valueOf((float)this.left.samples().get().intValue() / (float)(this.left.samples().get() + this.right.samples().get())));
        }
        return Optional.empty();
    }

    protected abstract String rankingExpressionCondition();

    public static FeatureNode fromDom(Node node) {
        List<Element> children = XmlHelper.getChildElements(node, null);
        if (children.size() != 2) {
            throw new IllegalArgumentException("Expected 2 children in element '" + node.getNodeName() + "', got " + children.size() + ".");
        }
        String name = XmlHelper.getAttributeText(node, "feature");
        Value[] values = FeatureNode.toValues(XmlHelper.getAttributeText(node, "value"));
        Optional<Integer> samples = FeatureNode.toInteger(XmlHelper.getOptionalAttributeText(node, "nSamples"));
        TreeNode left = TreeNode.fromDom(children.get(0));
        TreeNode right = TreeNode.fromDom(children.get(1));
        if (name.endsWith("$") || values.length > 1 || values[0] instanceof StringValue) {
            return new CategoryFeatureNode(name, values, samples, left, right);
        }
        return new NumericFeatureNode(name, values[0], samples, left, right);
    }

    private static Value[] toValues(String valueListString) {
        String[] valueStrings = valueListString.split(",");
        Value[] values = new Value[valueStrings.length];
        for (int i = 0; i < valueStrings.length; ++i) {
            try {
                values[i] = Value.parse(valueStrings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                values[i] = new StringValue(valueStrings[i]);
            }
        }
        return values;
    }
}

