/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.Operator;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.Join;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public final class OperationNode
extends CompositeNode {
    private static final Logger logger = Logger.getLogger(OperationNode.class.getName());
    private final List<ExpressionNode> children;
    private final List<Operator> operators;

    public OperationNode(List<ExpressionNode> children, List<Operator> operators) {
        int needChildren;
        this.children = List.copyOf(children);
        this.operators = List.copyOf(operators);
        if (operators.isEmpty()) {
            logger.warning("Strange: no operators for OperationNode");
        }
        if ((needChildren = operators.size() + 1) != children.size()) {
            throw new IllegalArgumentException("Need " + needChildren + " children, but got " + children.size());
        }
    }

    public OperationNode(ExpressionNode leftExpression, Operator operator, ExpressionNode rightExpression) {
        this.children = List.of(leftExpression, rightExpression);
        this.operators = List.of(operator);
    }

    public List<Operator> operators() {
        return this.operators;
    }

    @Override
    public List<ExpressionNode> children() {
        return this.children;
    }

    @Override
    public StringBuilder toString(StringBuilder string, SerializationContext context, Deque<String> path, CompositeNode parent) {
        boolean nonDefaultPrecedence = this.nonDefaultPrecedence(parent);
        if (nonDefaultPrecedence) {
            string.append("(");
        }
        Iterator<ExpressionNode> child = this.children.iterator();
        child.next().toString(string, context, path, this);
        if (child.hasNext()) {
            string.append(" ");
        }
        Iterator<Operator> op = this.operators.iterator();
        while (op.hasNext() && child.hasNext()) {
            string.append(op.next().toString()).append(" ");
            child.next().toString(string, context, path, this);
            if (!op.hasNext()) continue;
            string.append(" ");
        }
        if (nonDefaultPrecedence) {
            string.append(")");
        }
        return string;
    }

    private boolean nonDefaultPrecedence(CompositeNode parent) {
        if (parent == null) {
            return false;
        }
        if (!(parent instanceof OperationNode)) {
            return false;
        }
        OperationNode operationParent = (OperationNode)parent;
        if (operationParent.operators.size() != 1 || this.operators.size() != 1) {
            return true;
        }
        return operationParent.operators.get(0).hasPrecedenceOver(this.operators.get(0));
    }

    @Override
    public TensorType type(TypeContext<Reference> context) {
        TensorType type = this.children.get(0).type(context);
        for (int i = 1; i < this.children.size(); ++i) {
            type = Join.outputType((TensorType)type, (TensorType)this.children.get(i).type(context));
        }
        return type;
    }

    @Override
    public Value evaluate(Context context) {
        Iterator<ExpressionNode> child = this.children.iterator();
        ArrayDeque<ValueItem> stack = new ArrayDeque<ValueItem>();
        stack.push(new ValueItem(null, child.next().evaluate(context)));
        Iterator<Operator> it = this.operators.iterator();
        while (it.hasNext() && child.hasNext()) {
            Operator op = it.next();
            if (!stack.isEmpty()) {
                while (stack.size() > 1 && !op.hasPrecedenceOver(((ValueItem)stack.peek()).op)) {
                    this.popStack(stack);
                }
            }
            stack.push(new ValueItem(op, child.next().evaluate(context)));
        }
        while (stack.size() > 1) {
            this.popStack(stack);
        }
        return ((ValueItem)stack.getFirst()).value;
    }

    private void popStack(Deque<ValueItem> stack) {
        ValueItem rhs = stack.pop();
        ValueItem lhs = stack.peek();
        lhs.value = rhs.op.evaluate(lhs.value, rhs.value);
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> newChildren) {
        if (this.children.size() != newChildren.size()) {
            throw new IllegalArgumentException("Expected " + this.children.size() + " children but got " + newChildren.size());
        }
        return new OperationNode(newChildren, this.operators);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.children, this.operators);
    }

    public static OperationNode resolve(ExpressionNode left, Operator op, ExpressionNode right) {
        if (!(left instanceof OperationNode)) {
            return new OperationNode(left, op, right);
        }
        OperationNode leftArithmetic = (OperationNode)left;
        ArrayList<ExpressionNode> newChildren = new ArrayList<ExpressionNode>(leftArithmetic.children());
        newChildren.add(right);
        ArrayList<Operator> newOperators = new ArrayList<Operator>(leftArithmetic.operators());
        newOperators.add(op);
        return new OperationNode(newChildren, newOperators);
    }

    private static class ValueItem {
        final Operator op;
        Value value;

        public ValueItem(Operator op, Value value) {
            this.op = op;
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

