/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.BucketResultNode;
import com.yahoo.searchlib.expression.RawResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class RawBucketResultNode
extends BucketResultNode {
    public static final int classId = RawBucketResultNode.registerClass((int)16509, RawBucketResultNode.class, RawBucketResultNode::new);
    private ResultNode from = RawResultNode.getNegativeInfinity();
    private ResultNode to = RawResultNode.getNegativeInfinity();

    @Override
    public boolean empty() {
        return this.to.equals(this.from);
    }

    public RawBucketResultNode() {
    }

    public RawBucketResultNode(ResultNode from, ResultNode to) {
        this.from = from;
        this.to = to;
    }

    public byte[] getFrom() {
        return this.from.getRaw();
    }

    public byte[] getTo() {
        return this.to.getRaw();
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        RawBucketResultNode.serializeOptional((Serializer)buf, (Identifiable)this.from);
        RawBucketResultNode.serializeOptional((Serializer)buf, (Identifiable)this.to);
    }

    protected void onDeserialize(Deserializer buf) {
        this.from = (ResultNode)RawBucketResultNode.deserializeOptional((Deserializer)buf);
        this.to = (ResultNode)RawBucketResultNode.deserializeOptional((Deserializer)buf);
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        RawBucketResultNode b = (RawBucketResultNode)rhs;
        int diff = this.from.compareTo(b.from);
        return diff == 0 ? this.to.compareTo(b.to) : diff;
    }

    public int hashCode() {
        return super.hashCode() + this.from.hashCode() + this.to.hashCode();
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("from", (Object)this.from);
        visitor.visit("to", (Object)this.to);
    }
}

