/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.Deque;
import java.util.List;
import java.util.Objects;

public final class IfNode
extends CompositeNode {
    private final List<ExpressionNode> arguments;
    private final Double trueProbability;

    public IfNode(ExpressionNode condition, ExpressionNode trueExpression, ExpressionNode falseExpression) {
        this(condition, trueExpression, falseExpression, null);
    }

    public IfNode(ExpressionNode condition, ExpressionNode trueExpression, ExpressionNode falseExpression, Double trueProbability) {
        if (trueProbability != null && (trueProbability < 0.0 || trueProbability > 1.0)) {
            throw new IllegalArgumentException("trueProbability must be a between 0.0 and 1.0, not " + trueProbability);
        }
        this.trueProbability = trueProbability;
        this.arguments = List.of(condition, trueExpression, falseExpression);
    }

    @Override
    public List<ExpressionNode> children() {
        return this.arguments;
    }

    public ExpressionNode getCondition() {
        return this.arguments.get(0);
    }

    public ExpressionNode getTrueExpression() {
        return this.arguments.get(1);
    }

    public ExpressionNode getFalseExpression() {
        return this.arguments.get(2);
    }

    public Double getTrueProbability() {
        return this.trueProbability;
    }

    @Override
    public StringBuilder toString(StringBuilder string, SerializationContext context, Deque<String> path, CompositeNode parent) {
        string.append("if (");
        this.getCondition().toString(string, context, path, this).append(", ");
        this.getTrueExpression().toString(string, context, path, this).append(", ");
        this.getFalseExpression().toString(string, context, path, this);
        if (this.trueProbability != null) {
            string.append(", ").append(this.trueProbability);
        }
        return string.append(')');
    }

    @Override
    public TensorType type(TypeContext<Reference> context) {
        TensorType trueType = this.getTrueExpression().type(context);
        TensorType falseType = this.getFalseExpression().type(context);
        return (TensorType)trueType.dimensionwiseGeneralizationWith(falseType).orElseThrow(() -> new IllegalArgumentException("An if expression must produce compatible types in both alternatives, but the 'true' type is " + String.valueOf(trueType) + " while the 'false' type is " + String.valueOf(falseType) + "\n'true' branch: " + String.valueOf(this.getTrueExpression()) + "\n'false' branch: " + String.valueOf(this.getFalseExpression())));
    }

    @Override
    public Value evaluate(Context context) {
        if (this.getCondition().evaluate(context).asBoolean()) {
            return this.getTrueExpression().evaluate(context);
        }
        return this.getFalseExpression().evaluate(context);
    }

    @Override
    public IfNode setChildren(List<ExpressionNode> children) {
        if (children.size() != 3) {
            throw new IllegalArgumentException("Expected 3 children but got " + children.size());
        }
        return new IfNode(children.get(0), children.get(1), children.get(2));
    }

    @Override
    public int hashCode() {
        return Objects.hash("if", this.arguments, this.trueProbability);
    }
}

