/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.utils;

import ai.vespa.modelintegration.evaluator.OnnxStreamParser;
import ai.vespa.modelintegration.utils.ModelPathHelper;
import ai.vespa.modelintegration.utils.ModelPathHelperImpl;
import com.yahoo.config.ModelReference;
import com.yahoo.config.UrlReference;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OnnxExternalDataResolver {
    private static final Logger log = Logger.getLogger(OnnxExternalDataResolver.class.getName());
    private final ModelPathHelper modelPathHelper;

    public OnnxExternalDataResolver(ModelPathHelper modelPathHelper) {
        this.modelPathHelper = modelPathHelper;
    }

    public OnnxExternalDataResolver() {
        this(new ModelPathHelperImpl(__ -> {
            throw new UnsupportedOperationException("Bearer token protected ONNX models are not supported in this context.");
        }));
    }

    public Path resolveOnnxModel(ModelReference ref) {
        Path localPath = this.modelPathHelper.getModelPathResolvingIfNecessary(ref);
        if (OnnxExternalDataResolver.shouldSkipExternalDataResolution(ref)) {
            return localPath;
        }
        try {
            Set<Path> externalDataLocations = OnnxStreamParser.getExternalDataLocations(localPath);
            if (externalDataLocations.isEmpty()) {
                return localPath;
            }
            log.fine(() -> "Found external data locations for ONNX model '%s': %s".formatted(ref, externalDataLocations));
            String url = ((UrlReference)ref.url().get()).value();
            String urlPrefix = url.substring(0, url.lastIndexOf(47) + 1);
            HashMap<Path, Path> externalDataFiles = new HashMap<Path, Path>();
            for (Path location : externalDataLocations) {
                String dataFileUrl = urlPrefix + String.valueOf(location);
                log.info("Downloading external data file '%s' for ONNX model '%s' using URL '%s'".formatted(location, localPath.getFileName(), dataFileUrl));
                ModelReference externalDataRef = ModelReference.unresolved(Optional.empty(), Optional.of(new UrlReference(dataFileUrl)), (Optional)ref.secretRef(), Optional.empty());
                Path externalDataLocalPath = this.modelPathHelper.getModelPathResolvingIfNecessary(externalDataRef);
                externalDataFiles.put(location, externalDataLocalPath);
            }
            return OnnxExternalDataResolver.createDirectoryWithExternalDataFiles(localPath, externalDataFiles).resolve(localPath.getFileName());
        }
        catch (IOException e) {
            log.warning("Failed to resolve external data files for ONNX model '%s': %s".formatted(ref, e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            return localPath;
        }
    }

    private static boolean shouldSkipExternalDataResolution(ModelReference ref) {
        if (ref.path() != null && ref.path().isPresent()) {
            log.fine(() -> "Model reference '%s' has no local path, cannot resolve external data files".formatted(ref));
            return true;
        }
        if (ref.url() == null || ref.url().isEmpty()) {
            log.fine(() -> "Model reference '%s' has no URL, cannot resolve external data files".formatted(ref));
            return true;
        }
        String modelUrl = ((UrlReference)ref.url().get()).value();
        if (!modelUrl.endsWith(".onnx") || !modelUrl.contains("/")) {
            log.fine(() -> "URL does refer to ONNX model file name: '%s'".formatted(modelUrl));
            return true;
        }
        return false;
    }

    static Path createDirectoryWithExternalDataFiles(Path model, Map<Path, Path> externalDataFiles) throws IOException {
        Path tempDir = Files.createTempDirectory("onnx-model-", new FileAttribute[0]);
        if (!Files.exists(model, LinkOption.NOFOLLOW_LINKS) && !Files.isRegularFile(model, new LinkOption[0])) {
            throw new IllegalArgumentException("Model file does not exist: " + String.valueOf(model));
        }
        Path targetModelPath = tempDir.resolve(model.getFileName());
        log.fine(() -> "Creating symlink for '%s' to '%s'".formatted(model, targetModelPath));
        Files.createSymbolicLink(targetModelPath, model.toAbsolutePath(), new FileAttribute[0]);
        for (Map.Entry<Path, Path> entry : externalDataFiles.entrySet()) {
            Path relativeLocation = entry.getKey();
            Path dataFile = entry.getValue().toAbsolutePath();
            if (!Files.exists(dataFile, LinkOption.NOFOLLOW_LINKS) || !Files.isRegularFile(dataFile, new LinkOption[0])) {
                throw new IllegalArgumentException("External data file does not exist: " + String.valueOf(dataFile));
            }
            Path targetPath = tempDir.resolve(relativeLocation);
            Path parentDir = targetPath.getParent();
            if (parentDir != null && !Files.exists(parentDir, LinkOption.NOFOLLOW_LINKS)) {
                log.fine(() -> "Creating parent directory for symlink: '%s'".formatted(parentDir));
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            log.fine(() -> "Creating symlink for external data file '%s' to '%s'".formatted(dataFile, targetPath));
            Files.createSymbolicLink(targetPath, dataFile, new FileAttribute[0]);
        }
        return tempDir;
    }
}

