/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Map;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

public class Join
extends IntermediateOperation {
    private final DoubleBinaryOperator operator;

    public Join(String modelName, String nodeName, List<IntermediateOperation> inputs, DoubleBinaryOperator operator) {
        super(modelName, nodeName, inputs);
        this.operator = operator;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        OrderedTensorType a = this.largestInput().type().get();
        OrderedTensorType b = this.smallestInput().type().get();
        OrderedTensorType.Builder builder = new OrderedTensorType.Builder(this.resultValueType());
        int sizeDifference = a.rank() - b.rank();
        for (int i = 0; i < a.rank(); ++i) {
            TensorType.Dimension aDim = a.dimensions().get(i);
            long size = aDim.size().orElse(-1L);
            if (i - sizeDifference >= 0) {
                TensorType.Dimension bDim = b.dimensions().get(i - sizeDifference);
                size = Math.max(size, bDim.size().orElse(-1L));
            }
            if (aDim.type() == TensorType.Dimension.Type.indexedBound) {
                builder.add(TensorType.Dimension.indexed((String)aDim.name(), (long)size));
                continue;
            }
            if (aDim.type() == TensorType.Dimension.Type.indexedUnbound) {
                builder.add(TensorType.Dimension.indexed((String)aDim.name()));
                continue;
            }
            if (aDim.type() != TensorType.Dimension.Type.mapped) continue;
            builder.add(TensorType.Dimension.mapped((String)aDim.name()));
        }
        return builder.build();
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        Optional<DoubleUnaryOperator> mapOperator;
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        if (!this.allInputFunctionsPresent(2)) {
            return null;
        }
        if (((IntermediateOperation)this.inputs.get(0)).equals(this.inputs.get(1)) && (mapOperator = this.operatorAsUnary(this.operator)).isPresent()) {
            IntermediateOperation input = (IntermediateOperation)this.inputs.get(0);
            input.removeDuplicateOutputsTo(this);
            return new Map(input.function().get(), mapOperator.get());
        }
        IntermediateOperation a = this.largestInput();
        IntermediateOperation b = this.smallestInput();
        ArrayList<String> aDimensionsToReduce = new ArrayList<String>();
        ArrayList<String> bDimensionsToReduce = new ArrayList<String>();
        int sizeDifference = a.type().get().rank() - b.type().get().rank();
        for (int i = 0; i < b.type().get().rank(); ++i) {
            TensorType.Dimension bDim = b.type().get().dimensions().get(i);
            TensorType.Dimension aDim = a.type().get().dimensions().get(i + sizeDifference);
            long bSize = bDim.size().orElse(-1L);
            long aSize = aDim.size().orElse(-1L);
            if (bSize == 1L && aSize != 1L) {
                bDimensionsToReduce.add(bDim.name());
            }
            if (aSize != 1L || bSize == 1L) continue;
            aDimensionsToReduce.add(bDim.name());
        }
        Reduce aReducedFunction = a.function().get();
        if (aDimensionsToReduce.size() > 0) {
            aReducedFunction = new Reduce(a.function().get(), Reduce.Aggregator.sum, aDimensionsToReduce);
        }
        Reduce bReducedFunction = b.function().get();
        if (bDimensionsToReduce.size() > 0) {
            bReducedFunction = new Reduce(b.function().get(), Reduce.Aggregator.sum, bDimensionsToReduce);
        }
        if (a == this.inputs.get(1)) {
            Reduce temp = bReducedFunction;
            bReducedFunction = aReducedFunction;
            aReducedFunction = temp;
        }
        return new com.yahoo.tensor.functions.Join((TensorFunction)aReducedFunction, (TensorFunction)bReducedFunction, this.operator);
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        if (!this.allInputTypesPresent(2)) {
            return;
        }
        OrderedTensorType a = this.largestInput().type().get();
        OrderedTensorType b = this.smallestInput().type().get();
        int sizeDifference = a.rank() - b.rank();
        for (int i = 0; i < b.rank(); ++i) {
            String bDim = b.dimensions().get(i).name();
            String aDim = a.dimensions().get(i + sizeDifference).name();
            renamer.addConstraint(aDim, bDim, DimensionRenamer.Constraint.equal(false), this);
        }
    }

    private IntermediateOperation largestInput() {
        OrderedTensorType a = ((IntermediateOperation)this.inputs.get(0)).type().get();
        OrderedTensorType b = ((IntermediateOperation)this.inputs.get(1)).type().get();
        return a.rank() >= b.rank() ? (IntermediateOperation)this.inputs.get(0) : (IntermediateOperation)this.inputs.get(1);
    }

    private IntermediateOperation smallestInput() {
        OrderedTensorType a = ((IntermediateOperation)this.inputs.get(0)).type().get();
        OrderedTensorType b = ((IntermediateOperation)this.inputs.get(1)).type().get();
        return a.rank() < b.rank() ? (IntermediateOperation)this.inputs.get(0) : (IntermediateOperation)this.inputs.get(1);
    }

    @Override
    public Join withInputs(List<IntermediateOperation> inputs) {
        return new Join(this.modelName(), this.name(), inputs, this.operator);
    }

    @Override
    public String operationName() {
        return "Join";
    }

    private Optional<DoubleUnaryOperator> operatorAsUnary(final DoubleBinaryOperator op) {
        String unaryRep;
        if (op instanceof ScalarFunctions.Add) {
            unaryRep = "f(a)(a + a)";
        } else if (op instanceof ScalarFunctions.Multiply) {
            unaryRep = "f(a)(a * a)";
        } else if (op instanceof ScalarFunctions.Subtract) {
            unaryRep = "f(a)(0)";
        } else if (op instanceof ScalarFunctions.Divide) {
            unaryRep = "f(a)(1)";
        } else if (op instanceof ScalarFunctions.Equal) {
            unaryRep = "f(a)(1)";
        } else if (op instanceof ScalarFunctions.Greater) {
            unaryRep = "f(a)(0)";
        } else if (op instanceof ScalarFunctions.Less) {
            unaryRep = "f(a)(0)";
        } else if (op instanceof ScalarFunctions.Max) {
            unaryRep = "f(a)(a)";
        } else if (op instanceof ScalarFunctions.Min) {
            unaryRep = "f(a)(a)";
        } else if (op instanceof ScalarFunctions.Mean) {
            unaryRep = "f(a)(a)";
        } else if (op instanceof ScalarFunctions.Pow) {
            unaryRep = "f(a)(pow(a,a))";
        } else if (op instanceof ScalarFunctions.SquaredDifference) {
            unaryRep = "f(a)(0)";
        } else {
            return Optional.empty();
        }
        return Optional.of(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double operand) {
                return op.applyAsDouble(operand, operand);
            }

            public String toString() {
                return unaryRep;
            }
        });
    }
}

